/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusChange;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusTransitionedMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueStatusTransitionedEventWhenHandler
implements EventWhenHandler<IssueChangedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(IssueStatusTransitionedEventWhenHandler.class);
    private final IssueMessageHelper issueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final WhenUtils whenUtils;
    private final StatusTransitionedMessageHelper statusTransitionedMessageHelper;

    public IssueStatusTransitionedEventWhenHandler(IssueMessageHelper issueMessageHelper, UserMessageHelper userMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, RuleMessageBuilderService ruleMessageBuilderService, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, WhenUtils whenUtils, StatusTransitionedMessageHelper statusTransitionedMessageHelper) {
        this.userMessageHelper = userMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.issueMessageHelper = issueMessageHelper;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.whenUtils = whenUtils;
        this.statusTransitionedMessageHelper = statusTransitionedMessageHelper;
    }

    public Class<IssueChangedEvent> getEventClass() {
        return IssueChangedEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull IssueChangedEvent event) {
        if (!event.getChangeItemForField("status").isPresent()) {
            return Collections.emptyList();
        }
        LOG.debug("Handling status transition event. # of contexts found: {}", (Object)contexts.size());
        Issue issue = event.getIssue();
        List<RuleExecutionCommand> commands = this.createRuleExecutionCommands(contexts, event, issue);
        LOG.debug("# of matched rule references: {}", (Object)commands.size());
        return Collections.unmodifiableList(commands);
    }

    @VisibleForTesting
    List<RuleExecutionCommand> createRuleExecutionCommands(List<WhenHandlerContext> contexts, IssueChangedEvent event, Issue issue) {
        RuleExecutionCommandBuilder builder = this.prepareRuleExecutionCommandBuilder(event, issue);
        return contexts.stream().filter(context -> this.whenUtils.matchContextWithPermissionCheck((WhenHandlerContext)context, issue)).map(context -> builder.ruleReference(context.getRuleReference()).build()).collect(Collectors.toList());
    }

    @VisibleForTesting
    RuleExecutionCommandBuilder prepareRuleExecutionCommandBuilder(IssueChangedEvent event, Issue issue) {
        RuleMessage message = this.createRuleMessage(event, issue);
        return this.ruleExecutionCommandBuilderService.builder().ruleMessage(message);
    }

    @VisibleForTesting
    RuleMessage createRuleMessage(IssueChangedEvent event, Issue issue) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        this.addIssueToMessage(issue, builder);
        this.addUserToMessage(event, builder);
        this.addStatusTransitionToMessage(event, builder);
        this.addEventTimeToMessage(event, builder);
        return builder.build();
    }

    @VisibleForTesting
    void addIssueToMessage(Issue issue, RuleMessageBuilder builder) {
        this.issueMessageHelper.setIssueData(builder, issue);
    }

    @VisibleForTesting
    void addUserToMessage(IssueChangedEvent event, RuleMessageBuilder builder) {
        event.getAuthor().ifPresent(user -> this.addUserToMessage(builder, (ApplicationUser)user));
    }

    private void addUserToMessage(RuleMessageBuilder builder, ApplicationUser user) {
        String userKey = user.getKey();
        this.userMessageHelper.setUser(builder, "currentUser", userKey);
    }

    @VisibleForTesting
    void addStatusTransitionToMessage(IssueChangedEvent event, RuleMessageBuilder builder) {
        event.getChangeItemForField("status").ifPresent(changeItem -> this.statusTransitionedMessageHelper.setStatusTransitioned(builder, new StatusChange(changeItem.getFrom(), changeItem.getTo())));
    }

    private void addEventTimeToMessage(IssueChangedEvent event, RuleMessageBuilder builder) {
        this.eventTimeMessageHelper.setEventTime(builder, this.whenUtils.retrieveEventTimeOrNow((JiraEvent)event));
    }
}

