/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.event.ServiceDeskCommentEvent;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.CommentMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCommentEventWhenHandler
implements EventWhenHandler<ServiceDeskCommentEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommentEventWhenHandler.class);
    private final IssueMessageHelper issueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final CommentMessageHelper commentMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final WhenUtils whenUtils;

    AbstractCommentEventWhenHandler(IssueMessageHelper issueMessageHelper, UserMessageHelper userMessageHelper, CommentMessageHelper commentMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, RuleMessageBuilderService ruleMessageBuilderService, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, WhenUtils whenUtils) {
        this.issueMessageHelper = issueMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.commentMessageHelper = commentMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.whenUtils = whenUtils;
    }

    abstract boolean isApplicableCommentEvent(@Nonnull ServiceDeskCommentEvent var1);

    public Class<ServiceDeskCommentEvent> getEventClass() {
        return ServiceDeskCommentEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull ServiceDeskCommentEvent event) {
        if (event.getComment() == null) {
            return Collections.emptyList();
        }
        if (!this.isApplicableCommentEvent(event)) {
            return Collections.emptyList();
        }
        LOG.debug("Handling IssueEvent with comment. # of contexts found: {}", (Object)contexts.size());
        RuleMessage message = this.createRuleMessage(event);
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(message);
        ArrayList commands = Lists.newArrayList();
        for (WhenHandlerContext context : contexts) {
            if (!this.matchContext(context, event)) continue;
            RuleExecutionCommand command = builder.ruleReference(context.getRuleReference()).build();
            commands.add(command);
        }
        LOG.debug("# of commands: {}", (Object)commands.size());
        return commands;
    }

    private boolean matchContext(@Nonnull WhenHandlerContext context, @Nonnull ServiceDeskCommentEvent event) {
        return this.whenUtils.matchContextWithPermissionCheck(context, event.getIssue());
    }

    private RuleMessage createRuleMessage(ServiceDeskCommentEvent event) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        this.issueMessageHelper.setIssueData(builder, event.getIssue());
        ApplicationUser user = event.getUser();
        if (user != null) {
            this.userMessageHelper.setUser(builder, "currentUser", user.getKey());
        }
        ServiceDeskComment comment = event.getComment();
        this.commentMessageHelper.setCommentData(builder, comment.getComment());
        this.commentMessageHelper.setCommentEditedFlag(builder, !event.isCreatedEvent());
        this.eventTimeMessageHelper.setEventTime(builder, event.getTime());
        return builder.build();
    }
}

