/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.configuration;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.analytics.EditIssueThenActionAnalytics;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.configuration.EditIssueThenActionConfigurationHelper;
import com.atlassian.servicedesk.plugins.automation.spi.configuration.ConfigurationProcessor;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditIssueThenActionConfigurationProcessor
implements ConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EditIssueThenActionConfigurationProcessor.class);
    private static final String NEW_VALUE_PREFIX = "nv_";
    private final EditIssueThenActionConfigurationHelper configurationHelper;
    private final ProjectComponentManager projectComponentManager;
    private final EditIssueThenActionAnalytics editIssueThenActionAnalytics;

    public EditIssueThenActionConfigurationProcessor(EditIssueThenActionConfigurationHelper configurationHelper, ProjectComponentManager projectComponentManager, EditIssueThenActionAnalytics editIssueThenActionAnalytics) {
        this.configurationHelper = configurationHelper;
        this.projectComponentManager = projectComponentManager;
        this.editIssueThenActionAnalytics = editIssueThenActionAnalytics;
    }

    public Map<String, String> postLoad(Map<String, String> loadedConfiguration) {
        return loadedConfiguration;
    }

    public Map<String, String> preStore(Map<String, String> configurationToStore) {
        if (configurationToStore.isEmpty() || !this.isComponentsField(configurationToStore)) {
            return configurationToStore;
        }
        Option updatedConfigurationOpt = Steps.begin(this.configurationHelper.retrieveProjectId(configurationToStore)).then(projectId -> this.configurationHelper.extractStoredFieldValue(configurationToStore).toOption()).yield((projectId, storedFieldValue) -> this.updateConfigurationWithNewComponents((long)projectId, configurationToStore, (Map<String, String[]>)storedFieldValue));
        return (Map)updatedConfigurationOpt.getOr(() -> {
            LOG.error("Failed to extract Components field value to create new Components on-the-fly");
            return configurationToStore;
        });
    }

    private boolean isComponentsField(Map<String, String> data) {
        return this.configurationHelper.retrieveFieldId(data).exists("components"::equals);
    }

    private Map<String, String> updateConfigurationWithNewComponents(long projectId, Map<String, String> configurationToStore, Map<String, String[]> storedFieldValue) {
        Option updatedStoredFieldValueJsonOpt = Option.option((Object)storedFieldValue.get("components")).map(components -> this.createNewComponents(projectId, (String[])components)).flatMap(updatedComponents -> {
            HashMap<String, String[]> updatedStoredFieldValue = new HashMap<String, String[]>(storedFieldValue);
            updatedStoredFieldValue.put("components", (String[])updatedComponents);
            return this.configurationHelper.serialiseFieldValue(updatedStoredFieldValue);
        });
        return (Map)updatedStoredFieldValueJsonOpt.fold(() -> configurationToStore, updatedStoredFieldValueJson -> {
            HashMap<String, String> updatedConfiguration = new HashMap<String, String>(configurationToStore);
            updatedConfiguration.put("fieldValue", (String)updatedStoredFieldValueJson);
            return updatedConfiguration;
        });
    }

    private String[] createNewComponents(long projectId, String[] fieldValue) {
        ArrayList result = Lists.newArrayListWithCapacity((int)fieldValue.length);
        for (String componentIdOrNewValue : fieldValue) {
            if (componentIdOrNewValue.startsWith(NEW_VALUE_PREFIX)) {
                String newComponentName = componentIdOrNewValue.replaceFirst(NEW_VALUE_PREFIX, "");
                ProjectComponent newComponent = this.getOrCreateNewComponent(projectId, newComponentName);
                result.add(newComponent.getId().toString());
                continue;
            }
            result.add(componentIdOrNewValue);
        }
        return result.toArray(new String[result.size()]);
    }

    private ProjectComponent getOrCreateNewComponent(long projectId, String componentName) {
        return (ProjectComponent)Option.option((Object)this.projectComponentManager.findByComponentName(Long.valueOf(projectId), componentName)).getOr(() -> {
            ProjectComponent newComponent = this.projectComponentManager.create(componentName, null, null, 0L, Long.valueOf(projectId));
            LOG.debug("Created new component on-the-fly with name: " + componentName);
            this.editIssueThenActionAnalytics.fireComponentCreatedEvent(projectId);
            return newComponent;
        });
    }
}

