/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.configuration.EditIssueThenActionConfigurationHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class EditIssueThenActionValidator
implements ThenActionValidator {
    private static final String FIELD_SELECT_NAME = "edit-issue-field-select";
    private final EditIssueThenActionHelper editIssueThenActionHelper;
    private final EditIssueThenActionConfigurationHelper configurationHelper;

    public EditIssueThenActionValidator(EditIssueThenActionHelper editIssueThenActionHelper, EditIssueThenActionConfigurationHelper configurationHelper) {
        this.editIssueThenActionHelper = editIssueThenActionHelper;
        this.configurationHelper = configurationHelper;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam validationParam) {
        ApplicationUser user = validationParam.getUserToValidateWith();
        ConfigurationData configData = validationParam.getConfiguration().getData();
        Either result = this.configurationHelper.retrieveField(configData).leftMap(anError -> this.anErrorToFieldValidationError((AnError)anError, FIELD_SELECT_NAME)).flatMap(field -> this.editIssueThenActionHelper.validateFieldValue(user, configData, (OrderableField)field).leftMap(anError -> this.anErrorToFieldValidationError((AnError)anError, field.getId()))).map(unit -> ValidationResult.PASSED());
        return (ValidationResult)Eithers.merge((Either)result);
    }

    private ValidationResult anErrorToFieldValidationError(AnError anError, String formFieldName) {
        HashMap<String, ArrayList> errorMap = new HashMap<String, ArrayList>();
        errorMap.put(formFieldName, Lists.newArrayList((Object[])new String[]{anError.getMessage().getMessage()}));
        return ValidationResult.FAILED(errorMap);
    }
}

