/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.pocketknife.api.autowire.PluginAutowirer;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.editissue.EditIssueThenActionErrors;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import webwork.action.Action;

@Component
public class EditFieldHtmlRenderer {
    private final IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final I18nHelper i18nHelper;
    private final PluginAutowirer pluginAutowirer;
    private final EditIssueThenActionErrors editIssueThenActionErrors;

    @Autowired
    public EditFieldHtmlRenderer(IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, I18nHelper i18nHelper, PluginAutowirer pluginAutowirer, EditIssueThenActionErrors editIssueThenActionErrors) {
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.i18nHelper = i18nHelper;
        this.pluginAutowirer = pluginAutowirer;
        this.editIssueThenActionErrors = editIssueThenActionErrors;
    }

    public Either<AnError, String> retrieveFieldEditHtml(Project project, IssueType issueType, OrderableField field, Map<String, List<String>> params) {
        Map<String, String[]> actionParams = this.convertToActionParams(params);
        MutableIssue issue = this.createTemplateIssue(project, issueType);
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.retrieveFieldScreenRenderLayoutItem(issue, field);
        HashMap fieldValuesHolder = new HashMap();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder);
        if (field.hasParam(actionParams)) {
            field.populateFromParams(fieldValuesHolder, actionParams);
        }
        return this.retrieveFieldEditHtml(field, fieldScreenRenderLayoutItem.getFieldLayoutItem(), (OperationContext)operationContext, issue);
    }

    public Either<AnError, Unit> validateFieldValue(Project project, IssueType issueType, OrderableField field, Map<String, List<String>> params) {
        Map<String, String[]> actionParams = this.convertToActionParams(params);
        MutableIssue issue = this.createTemplateIssue(project, issueType);
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.retrieveFieldScreenRenderLayoutItem(issue, field);
        HashMap fieldValuesHolder = new HashMap();
        OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (field.hasParam(actionParams)) {
            field.populateFromParams(fieldValuesHolder, actionParams);
            field.validateParams((OperationContext)operationContext, (ErrorCollection)errorCollection, this.i18nHelper, (Issue)issue, fieldScreenRenderLayoutItem);
        }
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)this.convertToAnError(errorCollection));
        }
        return Either.right((Object)Unit.VALUE);
    }

    private AnError convertToAnError(SimpleErrorCollection errorCollection) {
        ArrayList errors = new ArrayList();
        errorCollection.getErrors().values().forEach(errors::add);
        errors.addAll(errorCollection.getErrorMessages());
        String errorMessage = StringUtils.join(errors, (String)", ");
        return new AnError(ErrorMessage.builder().message(errorMessage).build(), HttpStatusCode.BAD_REQUEST);
    }

    private FieldScreenRenderLayoutItem retrieveFieldScreenRenderLayoutItem(MutableIssue issue, OrderableField field) {
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer((Issue)issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
        return fieldScreenRenderer.getFieldScreenRenderLayoutItem(field);
    }

    private Either<AnError, String> retrieveFieldEditHtml(OrderableField field, FieldLayoutItem fieldLayoutItem, OperationContext operationContext, MutableIssue issue) {
        EditHtmlAction action = (EditHtmlAction)((Object)this.pluginAutowirer.autowire(EditHtmlAction.class));
        String editHtml = field.getEditHtml(fieldLayoutItem, operationContext, (Action)action, (Issue)issue, this.getFieldRenderParams());
        return Eithers.cond((boolean)StringUtils.isNotBlank((String)editHtml), (Object)this.editIssueThenActionErrors.FIELD_NOT_RENDERABLE(), (Object)editHtml);
    }

    private Map<String, Object> getFieldRenderParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("noHeader", "true");
        params.put("theme", "aui");
        params.put("isFirstField", Boolean.TRUE);
        params.put("isLastField", Boolean.TRUE);
        return params;
    }

    private Map<String, String[]> convertToActionParams(Map<String, List<String>> params) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        params.entrySet().forEach(keyValue -> {
            List value = (List)keyValue.getValue();
            if (value != null) {
                builder.put(keyValue.getKey(), (Object)value.toArray(new String[value.size()]));
            }
        });
        return builder.build();
    }

    private MutableIssue createTemplateIssue(Project project, IssueType issueType) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(project);
        issue.setIssueType(issueType);
        return issue;
    }

    private static class EditHtmlAction
    extends JiraWebActionSupport {
        private EditHtmlAction() {
        }
    }
}

