/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.approval;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.approval.AutoAnswerApprovalThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;

public class AutoAnswerApprovalThenActionVisualiser
implements RuleComponentVisualiser {
    private final I18nHelper.BeanFactory i18nFactory;
    private final AutoAnswerApprovalThenActionHelper autoAnswerApprovalThenActionHelper;

    public AutoAnswerApprovalThenActionVisualiser(I18nHelper.BeanFactory i18nFactory, AutoAnswerApprovalThenActionHelper autoAnswerApprovalThenActionHelper) {
        this.i18nFactory = i18nFactory;
        this.autoAnswerApprovalThenActionHelper = autoAnswerApprovalThenActionHelper;
    }

    @Nonnull
    public String getName(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        ApplicationUser user = ruleComponentVisualiserParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        return i18nHelper.getText("sd.action.auto.answer.approval.name");
    }

    @Nonnull
    public Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        ApplicationUser user = ruleComponentVisualiserParam.getUser();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        Either<ThenActionError, ApprovalDecisionType> decisionType = this.autoAnswerApprovalThenActionHelper.getAutoApprovalDecisionType(user, ruleComponentVisualiserParam.ruleConfiguration());
        if (decisionType.isLeft()) {
            return Option.none();
        }
        switch ((ApprovalDecisionType)decisionType.right().get()) {
            case APPROVED: {
                return Option.some((Object)i18nHelper.getText("sd.action.auto.answer.approval.label.approve"));
            }
            case REJECTED: {
                return Option.some((Object)i18nHelper.getText("sd.action.auto.answer.approval.label.decline"));
            }
        }
        return Option.none();
    }
}

