/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen.approval;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import io.atlassian.fugue.Unit;
import io.atlassian.fugue.retry.RetryFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class AutoAnswerApprovalThenActionHelper {
    private static Logger logger = LoggerFactory.getLogger(AutoAnswerApprovalThenActionHelper.class);
    public static final String APPROVAL_DECISION_TYPE = "approvalDecisionType";
    private static final int NUMBER_RETRIES = 10;
    private static final int BACKOFF_PERIOD = 5;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final InternalApprovalService approvalService;
    private final WorkflowManager workflowManager;

    @Autowired
    public AutoAnswerApprovalThenActionHelper(I18nHelper.BeanFactory i18nFactory, ThenActionErrorHelper thenActionErrorHelper, InternalApprovalService approvalService, WorkflowManager workflowManager) {
        this.i18nFactory = i18nFactory;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.approvalService = approvalService;
        this.workflowManager = workflowManager;
    }

    public io.atlassian.fugue.Either<ThenActionError, ApprovalDecisionType> getAutoApprovalDecisionType(ApplicationUser user, ConfigurationData configurationData) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option decisionTypeString = StepsConverters.newerOption((Option)configurationData.getValue(APPROVAL_DECISION_TYPE));
        if (decisionTypeString.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.auto.answer.approval.error.answer.type.required")));
        }
        io.atlassian.fugue.Option<ApprovalDecisionType> decisionType = this.getApprovalDecisionType((String)decisionTypeString.get());
        if (decisionType.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.auto.answer.approval.error.answer.type.invalid")));
        }
        return io.atlassian.fugue.Either.right((Object)decisionType.get());
    }

    public io.atlassian.fugue.Either<ThenActionError, Unit> resolveCurrentStatusActiveApprovals(ApplicationUser user, Issue issue, ApprovalDecisionType type) {
        Collection activeApprovalsAtCurrentStatus = this.approvalService.getActiveApprovals(issue).stream().filter(approval -> Objects.equals(issue.getStatusId(), approval.getStatusId())).collect(Collectors.toList());
        if (activeApprovalsAtCurrentStatus.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Unit.VALUE);
        }
        Supplier<Unit> retryUntilWorkflowActivation = this.getRetryUntilWorkflowActivatedSupplier(issue);
        try {
            retryUntilWorkflowActivation.get();
        }
        catch (RuntimeException e) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(this.i18nFactory.getInstance(user).getText("sd.action.auto.answer.approval.error.workflow.not.activated")));
        }
        for (Approval approval2 : activeApprovalsAtCurrentStatus) {
            io.atlassian.fugue.Either updateResult = this.approvalService.updateApprovalDecisionIgnoreSecurity(user, approval2, type);
            if (!updateResult.isLeft()) continue;
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)updateResult.left().get()));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.VALUE);
    }

    private Supplier<Unit> getRetryUntilWorkflowActivatedSupplier(Issue issue) {
        return RetryFactory.create(() -> {
            try {
                WorkflowEntry workflowEntry = this.workflowManager.getStore().findEntry(issue.getWorkflowId().longValue());
                if (workflowEntry == null || workflowEntry.getState() != 1) {
                    throw new RuntimeException("Workflow is not activated");
                }
                return Unit.Unit();
            }
            catch (StoreException e) {
                throw new RuntimeException(e);
            }
        }, (int)10, exception -> logger.debug(issue.getKey() + ": Retry has received an exception while retrieving the workflow state.", (Throwable)exception), (long)5L);
    }

    private io.atlassian.fugue.Option<ApprovalDecisionType> getApprovalDecisionType(String type) {
        try {
            ApprovalDecisionType approvalDecisionType = ApprovalDecisionType.forKey((String)type);
            return io.atlassian.fugue.Option.some((Object)approvalDecisionType);
        }
        catch (IllegalArgumentException ex) {
            return io.atlassian.fugue.Option.none();
        }
    }
}

