/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.spi.WorkflowEntry;
import io.atlassian.fugue.Unit;
import io.atlassian.fugue.retry.RetryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class WorkflowTransitionThenActionHelper {
    public static final String WORKFLOW_TARGET_CONFIG_NAME_KEY = "workflowAction";
    private static final String WORKFLOW_TARGET_FIELD_NAME = "actions";
    private static final Logger log = LoggerFactory.getLogger(WorkflowTransitionThenActionHelper.class);
    private static final int NUMBER_RETRIES = 12;
    private static final long BACKOFF_PERIOD = 5L;
    private final WorkflowManager workflowManager;
    private final IssueService issueService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ThenActionErrorHelper thenActionErrorHelper;

    @Autowired
    public WorkflowTransitionThenActionHelper(WorkflowManager workflowManager, IssueService issueService, I18nHelper.BeanFactory i18nFactory, ThenActionErrorHelper thenActionErrorHelper) {
        this.workflowManager = workflowManager;
        this.issueService = issueService;
        this.i18nFactory = i18nFactory;
        this.thenActionErrorHelper = thenActionErrorHelper;
    }

    @Nonnull
    public Set<String> getAllUniqueValidActionNamesForProject(@Nonnull Project project) {
        Assertions.notNull((String)"project", (Object)project);
        Collection issueTypes = project.getIssueTypes();
        HashSet jiraWorkflowList = Sets.newHashSet();
        for (IssueType issueType : issueTypes) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(project.getId(), issueType.getId());
            jiraWorkflowList.add(workflow);
        }
        HashSet actionNames = Sets.newHashSet();
        for (JiraWorkflow jiraWorkflow : jiraWorkflowList) {
            ArrayList allActions = Lists.newArrayList((Iterable)jiraWorkflow.getAllActions());
            ArrayList filteredActions = Lists.newArrayList();
            for (ActionDescriptor action : allActions) {
                if (jiraWorkflow.getActionType(action).equals("initial")) continue;
                filteredActions.add(action);
            }
            List actionDescriptorAsResponses = Lists.transform((List)filteredActions, (Function)new Function<ActionDescriptor, String>(){

                @Nullable
                public String apply(ActionDescriptor actionDescriptor) {
                    return actionDescriptor.getName();
                }
            });
            actionNames.addAll(actionDescriptorAsResponses);
        }
        return actionNames;
    }

    public boolean projectsHasAction(@Nonnull List<Project> projects, @Nonnull String actionName) {
        Assertions.notNull((String)"projects", projects);
        Assertions.isTrue((String)"actionName should not be empty", (boolean)StringUtils.isNotBlank((String)actionName));
        boolean hasAction = false;
        for (Project project : projects) {
            Set<String> allUniqueValidActionNamesForProject = this.getAllUniqueValidActionNamesForProject(project);
            if (!allUniqueValidActionNamesForProject.contains(actionName)) continue;
            hasAction = true;
            break;
        }
        return hasAction;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, String> getWorkflowActionName(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option workflowActionOption = StepsConverters.newerOption((Option)configurationData.getValue(WORKFLOW_TARGET_CONFIG_NAME_KEY));
        if (workflowActionOption.isEmpty() || StringUtils.isBlank((String)((String)workflowActionOption.get()))) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.workflow.transition.missing.action")));
        }
        return io.atlassian.fugue.Either.right((Object)workflowActionOption.get());
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, ActionDescriptor> getActionDescriptorForIssue(@Nonnull ApplicationUser user, @Nonnull String workflowActionName, @Nonnull Issue issue) {
        StepDescriptor step;
        Assertions.isTrue((String)"workflowActionName should not be empty", (boolean)StringUtils.isNotBlank((String)workflowActionName));
        Assertions.notNull((String)"issue", (Object)issue);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option workflowOpt = io.atlassian.fugue.Option.option((Object)this.workflowManager.getWorkflow(issue));
        if (workflowOpt.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.workflow.transition.missing.workflow")));
        }
        JiraWorkflow workflow = (JiraWorkflow)workflowOpt.get();
        List<ActionDescriptor> actionsForStep = this.getActionsForStep(workflow, step = workflow.getLinkedStep(issue.getStatus()));
        io.atlassian.fugue.Option actionDescriptorOpt = io.atlassian.fugue.Iterables.findFirst(actionsForStep, actionDescriptor -> actionDescriptor.getName().equalsIgnoreCase(workflowActionName));
        if (actionDescriptorOpt.isDefined()) {
            return io.atlassian.fugue.Either.right((Object)actionDescriptorOpt.get());
        }
        return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.workflow.transition.unavailable.action")));
    }

    private List<ActionDescriptor> getActionsForStep(final JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        List localActions = stepDescriptor.getActions();
        String GLOBAL_ACTION = "global";
        ArrayList globalActions = Lists.newArrayList((Iterable)Iterables.filter((Iterable)workflow.getAllActions(), (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor action) {
                return workflow.getActionType(action).equals("global");
            }
        }));
        ArrayList actionsForStep = Lists.newArrayList();
        actionsForStep.addAll(localActions);
        actionsForStep.addAll(globalActions);
        return actionsForStep;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, Unit> transitionIssue(@Nonnull ApplicationUser user, @Nonnull Issue issue, @Nonnull ActionDescriptor actionDescriptor) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"actionDescriptor", (Object)actionDescriptor);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        Supplier retryUntilActivation = RetryFactory.create(() -> {
            try {
                WorkflowEntry workflowEntry = (WorkflowEntry)Assertions.notNull((String)"workflow entry", (Object)this.workflowManager.getStore().findEntry(issue.getWorkflowId().longValue()));
                if (workflowEntry.isInitialized() || workflowEntry.getState() > 0) {
                    return Unit.Unit();
                }
                throw new RuntimeException("Workflow is not yet initialized");
            }
            catch (StoreException e) {
                throw new RuntimeException(e);
            }
        }, (int)12, exception -> log.debug(issue.getKey() + ": Retry has received an exception while retrieving the workflow state.", (Throwable)exception), (long)5L);
        try {
            retryUntilActivation.get();
            log.debug(issue.getKey() + ": The workflow is initialized, and now can attempt the actual transition");
        }
        catch (RuntimeException e) {
            log.warn(issue.getKey() + ": The workflow is not initialized, after a number of retries. Continuing with transition attempt anyway.", (Throwable)e);
        }
        IssueService.TransitionValidationResult transitionValidationResult = this.issueService.validateTransition(user, issue.getId(), actionDescriptor.getId(), this.issueService.newIssueInputParameters());
        if (transitionValidationResult.isValid()) {
            IssueService.IssueResult issueResult = this.issueService.transition(user, transitionValidationResult);
            if (issueResult.isValid()) {
                return io.atlassian.fugue.Either.right((Object)Unit.Unit());
            }
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.workflow.transition.transition.failed"), issueResult.getErrorCollection()));
        }
        return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.workflow.transition.transition.validation.failed"), transitionValidationResult.getErrorCollection()));
    }

    @Nonnull
    public ValidationResult getValidationResultFromError(@Nonnull ApplicationUser user, @Nonnull List<String> errorKeys) {
        Assertions.notNull((String)"errorKeys", errorKeys);
        final I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        CopyOnWriteMap validationErrors = CopyOnWriteMap.newHashMap();
        List translatedErrors = Lists.transform(errorKeys, (Function)new Function<String, String>(){

            @Nullable
            public String apply(String errorKey) {
                return i18nHelper.getText(errorKey);
            }
        });
        validationErrors.put(WORKFLOW_TARGET_FIELD_NAME, translatedErrors);
        return ValidationResult.FAILED((Map)validationErrors);
    }

    @Nonnull
    public ValidationResult getValidationResultFromError(@Nonnull ApplicationUser user, @Nonnull String errorKey) {
        Assertions.notNull((String)"errorKey", (Object)errorKey);
        return this.getValidationResultFromError(user, Lists.newArrayList((Object[])new String[]{errorKey}));
    }
}

