/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.WorkflowTransitionThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.opensymphony.workflow.loader.ActionDescriptor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowTransitionThenAction
implements ThenAction {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowTransitionThenAction.class);
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper;
    private final IssueMessageHelper issueMessageHelper;

    @Autowired
    public WorkflowTransitionThenAction(ThenActionErrorHelper thenActionErrorHelper, WorkflowTransitionThenActionHelper workflowTransitionThenActionHelper, IssueMessageHelper issueMessageHelper) {
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.workflowTransitionThenActionHelper = workflowTransitionThenActionHelper;
        this.issueMessageHelper = issueMessageHelper;
    }

    public Either<ThenActionError, RuleMessage> invoke(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        RuleMessage message = thenActionParam.getMessage();
        ApplicationUser user = thenActionParam.getUser();
        Either workflowActionNameEither = StepsConverters.olderEither(this.workflowTransitionThenActionHelper.getWorkflowActionName(user, thenActionParam.getConfiguration().getData()));
        if (workflowActionNameEither.isLeft()) {
            return Either.left((Object)workflowActionNameEither.left().get());
        }
        String workflowActionName = (String)workflowActionNameEither.right().get();
        Either issueEither = this.issueMessageHelper.getIssue(message);
        if (issueEither.isLeft()) {
            LOG.debug("Cannot find issue to act on. Can't execute action");
            return this.thenActionErrorHelper.error((AnError)issueEither.left().get());
        }
        Issue issue = (Issue)issueEither.right().get();
        Either actionDescriptorEither = StepsConverters.olderEither(this.workflowTransitionThenActionHelper.getActionDescriptorForIssue(user, workflowActionName, issue));
        if (actionDescriptorEither.isLeft()) {
            return Either.left((Object)actionDescriptorEither.left().get());
        }
        ActionDescriptor actionDescriptor = (ActionDescriptor)actionDescriptorEither.right().get();
        Either transitionResultEither = StepsConverters.olderEither(this.workflowTransitionThenActionHelper.transitionIssue(thenActionParam.getUser(), issue, actionDescriptor));
        if (transitionResultEither.isLeft()) {
            return Either.left((Object)transitionResultEither.left().get());
        }
        this.issueMessageHelper.invalidateIssue(message);
        return Either.right((Object)message);
    }
}

