/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.CreateInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.CreatePublicCommentParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.comment.ValidatedInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.ValidatedPublicCommentParameters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class ServiceDeskCommentThenActionHelper {
    public static final String INCLUDE_LINKED_ISSUE_DETAILS_CONFIG_KEY = "includeLinkedIssueDetails";
    public static final String COMMENT_CONFIG_KEY = "comment";
    private static final String COMMENT_FIELD_NAME = "comment";
    public static final String COMMENT_TYPE_CONFIG_KEY = "commentType";
    public static final String LINKED_ISSUE_DETAIL_CONFIG_KEY = "includeLinkedIssueDetails";
    private static final String COMMENT_TYPE_FIELD_NAME = "commentType";
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskCommentService serviceDeskCommentService;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final BuilderService builderService;

    @Autowired
    public ServiceDeskCommentThenActionHelper(I18nHelper.BeanFactory i18nFactory, ServiceDeskCommentService serviceDeskCommentService, ThenActionErrorHelper thenActionErrorHelper, BuilderService builderService) {
        this.i18nFactory = i18nFactory;
        this.serviceDeskCommentService = serviceDeskCommentService;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.builderService = builderService;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, CommentType> getCommentType(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"user", (Object)user);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option commentTypeStringOption = StepsConverters.newerOption((Option)configurationData.getValue("commentType"));
        if (commentTypeStringOption.isEmpty() || StringUtils.isBlank((String)((String)commentTypeStringOption.get()))) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.servicedesk.comment.type.missing")));
        }
        String commentTypeString = (String)commentTypeStringOption.get();
        io.atlassian.fugue.Option<CommentType> commentTypeOption = CommentType.getCommentType(commentTypeString);
        if (commentTypeOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.servicedesk.comment.type.missing")));
        }
        return io.atlassian.fugue.Either.right((Object)commentTypeOption.get());
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, String> getComment(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"user", (Object)user);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option commentOption = StepsConverters.newerOption((Option)configurationData.getValue("comment"));
        if (commentOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.action.servicedesk.comment.missing.comment")));
        }
        return io.atlassian.fugue.Either.right((Object)commentOption.get());
    }

    @Nonnull
    public io.atlassian.fugue.Option<Boolean> getIncludeLinkedIssueDetails(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"user", (Object)user);
        io.atlassian.fugue.Option includeLinkedIssueDetailsOption = StepsConverters.newerOption((Option)configurationData.getValue("includeLinkedIssueDetails"));
        if (includeLinkedIssueDetailsOption.isEmpty() || StringUtils.isBlank((String)((String)includeLinkedIssueDetailsOption.get()))) {
            return io.atlassian.fugue.Option.none();
        }
        String includeLinkedIssueDetails = (String)includeLinkedIssueDetailsOption.get();
        return io.atlassian.fugue.Option.option((Object)Boolean.valueOf(includeLinkedIssueDetails));
    }

    @Nonnull
    public io.atlassian.fugue.Either<AnError, ServiceDeskComment> makeComment(@Nonnull ApplicationUser user, @Nonnull String commentBody, @Nonnull Issue issue, CommentType commentType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"commentBody", (Object)commentBody);
        Assertions.notNull((String)"issue", (Object)issue);
        if (commentType == CommentType.Public) {
            return this.makePublicComment(user, commentBody, issue);
        }
        return this.makeInternalComment(user, commentBody, issue);
    }

    @Nonnull
    public Map<String, List<String>> generateCommentError(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        Assertions.notNull((String)"user", (Object)user);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        HashMap newFieldErrors = Maps.newHashMap();
        newFieldErrors.put("comment", Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)}));
        return newFieldErrors;
    }

    @Nonnull
    public Map<String, List<String>> generateCommentTypeError(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        Assertions.notNull((String)"i18nKey", (Object)i18nKey);
        Assertions.notNull((String)"user", (Object)user);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        HashMap newFieldErrors = Maps.newHashMap();
        newFieldErrors.put("commentType", Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)}));
        return ImmutableMap.copyOf((Map)newFieldErrors);
    }

    @Nonnull
    public ConfigurationData createConfigurationData(String comment, CommentType commentType) {
        return this.builderService.newConfigurationDataBuilder().put("comment", comment).put("commentType", commentType.toString()).build();
    }

    @Nonnull
    private io.atlassian.fugue.Either<AnError, ServiceDeskComment> makePublicComment(@Nonnull ApplicationUser user, @Nonnull String commentBody, @Nonnull Issue issue) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"commentBody", (Object)commentBody);
        Assertions.notNull((String)"issue", (Object)issue);
        CreatePublicCommentParameters createPublicCommentParameters = this.buildPublicCommentParameters(user, commentBody, issue);
        io.atlassian.fugue.Either validatedPublicCommentParametersEither = StepsConverters.newerEither((Either)this.serviceDeskCommentService.validatePublicComment(user, createPublicCommentParameters));
        if (validatedPublicCommentParametersEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validatedPublicCommentParametersEither.left().get());
        }
        ValidatedPublicCommentParameters validatedPublicCommentParameters = (ValidatedPublicCommentParameters)validatedPublicCommentParametersEither.right().get();
        return StepsConverters.newerEither((Either)this.serviceDeskCommentService.createPublicComment(user, validatedPublicCommentParameters));
    }

    @Nonnull
    private io.atlassian.fugue.Either<AnError, ServiceDeskComment> makeInternalComment(@Nonnull ApplicationUser user, @Nonnull String commentBody, @Nonnull Issue issue) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"commentBody", (Object)commentBody);
        Assertions.notNull((String)"issue", (Object)issue);
        CreateInternalCommentParameters createInternalCommentParameters = this.buildInternalCommentParameters(user, commentBody, issue);
        io.atlassian.fugue.Either validatedInternalCommentParametersEither = StepsConverters.newerEither((Either)this.serviceDeskCommentService.validateInternalComment(user, createInternalCommentParameters));
        if (validatedInternalCommentParametersEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validatedInternalCommentParametersEither.left().get());
        }
        ValidatedInternalCommentParameters validatedInternalCommentParameters = (ValidatedInternalCommentParameters)validatedInternalCommentParametersEither.right().get();
        return StepsConverters.newerEither((Either)this.serviceDeskCommentService.createInternalComment(user, validatedInternalCommentParameters));
    }

    @Nonnull
    private CreatePublicCommentParameters buildPublicCommentParameters(ApplicationUser user, String commentBody, Issue issue) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"commentBody", (Object)commentBody);
        Assertions.notNull((String)"issue", (Object)issue);
        return (CreatePublicCommentParameters)CreatePublicCommentParameters.newBuilder().author(user).body(commentBody).issue(issue).build();
    }

    @Nonnull
    private CreateInternalCommentParameters buildInternalCommentParameters(ApplicationUser user, String commentBody, Issue issue) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"commentBody", (Object)commentBody);
        Assertions.notNull((String)"issue", (Object)issue);
        return (CreateInternalCommentParameters)CreateInternalCommentParameters.newBuilder().author(user).body(commentBody).issue(issue).build();
    }
}

