/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestUpdateParameters;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@Internal
public class RequestTypeThenActionHelper {
    public static final String REQUEST_TYPE = "requestType";
    private final ServiceDeskCustomerRequestService customerRequestService;
    private final ServiceDeskManager serviceDeskManager;
    private final RequestTypeService requestTypeService;
    private final I18nHelper i18nHelper;
    private final ThenActionErrorHelper thenActionErrorHelper;

    @Autowired
    public RequestTypeThenActionHelper(ServiceDeskCustomerRequestService customerRequestService, ServiceDeskManager serviceDeskManager, RequestTypeService requestTypeService, I18nHelper i18nHelper, ThenActionErrorHelper thenActionErrorHelper) {
        this.customerRequestService = customerRequestService;
        this.serviceDeskManager = serviceDeskManager;
        this.requestTypeService = requestTypeService;
        this.i18nHelper = i18nHelper;
        this.thenActionErrorHelper = thenActionErrorHelper;
    }

    public io.atlassian.fugue.Either<ThenActionError, CustomerRequest> updateRequestType(ApplicationUser user, Issue issue, RequestType requestType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"issue", (Object)issue);
        Project project = issue.getProjectObject();
        io.atlassian.fugue.Either serviceDeskEither = StepsConverters.newerEither((Either)this.serviceDeskManager.getServiceDeskForProject(project));
        if (serviceDeskEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)serviceDeskEither.left().get()));
        }
        CustomerRequestUpdateParameters requestTypeUpdateParameters = this.customerRequestService.newUpdateBuilder().issue(issue).requestType(requestType).serviceDesk((ServiceDesk)serviceDeskEither.right().get()).build();
        io.atlassian.fugue.Either customerRequestEither = StepsConverters.newerEither((Either)this.customerRequestService.updateCustomerRequest(user, requestTypeUpdateParameters));
        if (customerRequestEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)customerRequestEither.left().get()));
        }
        return io.atlassian.fugue.Either.right((Object)customerRequestEither.right().get());
    }

    public io.atlassian.fugue.Either<ThenActionError, RequestType> getRequestType(ApplicationUser user, ConfigurationData configurationData) {
        Integer requestTypeId;
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        io.atlassian.fugue.Option requestTypeOpt = StepsConverters.newerOption((Option)configurationData.getValue(REQUEST_TYPE));
        if (requestTypeOpt.isEmpty() || StringUtils.isBlank((String)((String)requestTypeOpt.get()))) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(this.i18nHelper.getText("sd.action.request.type.is.empty")));
        }
        try {
            requestTypeId = Integer.valueOf((String)requestTypeOpt.get());
        }
        catch (NumberFormatException nfe) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(this.i18nHelper.getText("sd.action.request.type.is.not.number", (String)requestTypeOpt.get())));
        }
        RequestTypeQuery query = this.requestTypeService.newQueryBuilder().requestType(requestTypeId).build();
        return StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, query)).bimap(error -> (ThenActionError)this.thenActionErrorHelper.error(error).left().get(), pr -> (RequestType)pr.findFirst().get());
    }
}

