/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.AlertUserThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenActionValidator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class AlertUserThenActionValidator
implements ThenActionValidator {
    private final I18nHelper i18nHelper;
    private final UserManager userManager;
    private final AlertUserThenActionHelper alertUserThenActionHelper;

    @Autowired
    public AlertUserThenActionValidator(I18nHelper i18nHelper, UserManager userManager, AlertUserThenActionHelper alertUserThenActionHelper) {
        this.i18nHelper = i18nHelper;
        this.userManager = userManager;
        this.alertUserThenActionHelper = alertUserThenActionHelper;
    }

    public ValidationResult validate(@Nonnull ThenActionValidator.ThenActionValidationParam thenActionValidationParam) {
        Either<ThenActionError, List<String>> userKeyListEither = this.alertUserThenActionHelper.getConfiguredUserList(thenActionValidationParam.getUserToValidateWith(), thenActionValidationParam.getConfiguration().getData());
        if (userKeyListEither.isLeft()) {
            HashMap fieldErrors = Maps.newHashMap();
            fieldErrors.put("userKeys", Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText("sd.action.alert.user.missing.user.data")}));
            return ValidationResult.FAILED((Map)fieldErrors);
        }
        List userKeyList = (List)userKeyListEither.right().get();
        for (String userKey : userKeyList) {
            ApplicationUser userByKey = this.userManager.getUserByKey(userKey);
            if (userByKey != null) continue;
            HashMap fieldErrors = Maps.newHashMap();
            fieldErrors.put("userKeys", Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText("sd.action.alert.user.missing.user.name", userKey)}));
            return ValidationResult.FAILED((Map)fieldErrors);
        }
        return ValidationResult.PASSED();
    }
}

