/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.CreateInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.comment.ValidatedInternalCommentParameters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ConfigurationDataJsonHelper;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class AlertUserThenActionHelper {
    public static final String CONFIG_DATA_USER_KEY = "userKeys";
    public static final int MAX_USER_IN_LABEL = 3;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ConfigurationDataJsonHelper configurationDataJsonHelper;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final UserManager userManager;
    private final ServiceDeskCommentService serviceDeskCommentService;

    @Autowired
    public AlertUserThenActionHelper(I18nHelper.BeanFactory i18nFactory, ConfigurationDataJsonHelper configurationDataJsonHelper, ThenActionErrorHelper thenActionErrorHelper, UserManager userManager, ServiceDeskCommentService serviceDeskCommentService) {
        this.i18nFactory = i18nFactory;
        this.configurationDataJsonHelper = configurationDataJsonHelper;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.userManager = userManager;
        this.serviceDeskCommentService = serviceDeskCommentService;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, List<String>> getConfiguredUserList(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option userJsonOption = StepsConverters.newerOption((Option)configurationData.getValue(CONFIG_DATA_USER_KEY));
        if (userJsonOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error(i18nHelper.getText("sd.if.jql.missing.jql")));
        }
        String userJson = (String)userJsonOption.get();
        io.atlassian.fugue.Either<AnError, List<String>> userListEither = this.configurationDataJsonHelper.convertJsonToStringList(userJson);
        if (userListEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)userListEither.left().get()));
        }
        List userList = (List)userListEither.right().get();
        return io.atlassian.fugue.Either.right((Object)userList);
    }

    @Nonnull
    public String getAlertMessage(@Nonnull ApplicationUser user, @Nonnull List<String> userKeys) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        StringBuilder commentBodyBuilder = new StringBuilder();
        for (int i = 0; i < userKeys.size(); ++i) {
            String userKey = userKeys.get(i);
            ApplicationUser applicationUser = this.userManager.getUserByKey(userKey);
            if (applicationUser != null) {
                commentBodyBuilder.append("[~" + applicationUser.getUsername() + "]");
            }
            if (i == userKeys.size() - 1) continue;
            commentBodyBuilder.append(", ");
        }
        String alertMessage = i18nHelper.getText("sd.action.alert.user.message", commentBodyBuilder.toString());
        return alertMessage;
    }

    @Nonnull
    public io.atlassian.fugue.Either<ThenActionError, Unit> createAlert(@Nonnull ApplicationUser user, @Nonnull Issue issue, @Nonnull String alertMessage) {
        CreateInternalCommentParameters internalCommentParameters = (CreateInternalCommentParameters)CreateInternalCommentParameters.newBuilder().author(user).body(alertMessage).issue(issue).build();
        io.atlassian.fugue.Either internalCommentParametersEither = StepsConverters.newerEither((Either)this.serviceDeskCommentService.validateInternalComment(user, internalCommentParameters));
        if (internalCommentParametersEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.thenActionErrorHelper.error((AnError)internalCommentParametersEither.left().get()));
        }
        ValidatedInternalCommentParameters validatedInternalCommentParameters = (ValidatedInternalCommentParameters)internalCommentParametersEither.right().get();
        this.serviceDeskCommentService.createInternalComment(user, validatedInternalCommentParameters);
        return io.atlassian.fugue.Either.right((Object)Unit.UNIT);
    }

    public String getLabelFromUserKeys(@Nonnull ApplicationUser user, @Nonnull List<String> userKeysList) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"userKeysList", userKeysList);
        StringBuilder labelBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(userKeysList.size(), 3); ++i) {
            String userKey = userKeysList.get(i);
            labelBuilder.append(userKey);
            if (i == userKeysList.size() - 1) continue;
            labelBuilder.append(", ");
        }
        if (userKeysList.size() > 3) {
            labelBuilder.append("...");
        }
        return labelBuilder.toString();
    }
}

