/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulethen;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulethen.AlertUserThenActionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class AlertUserThenAction
implements ThenAction {
    private final IssueMessageHelper issueMessageHelper;
    private final ThenActionErrorHelper thenActionErrorHelper;
    private final AlertUserThenActionHelper alertUserThenActionHelper;

    @Autowired
    public AlertUserThenAction(@Nonnull IssueMessageHelper issueMessageHelper, @Nonnull ThenActionErrorHelper thenActionErrorHelper, @Nonnull AlertUserThenActionHelper alertUserThenActionHelper) {
        this.issueMessageHelper = issueMessageHelper;
        this.thenActionErrorHelper = thenActionErrorHelper;
        this.alertUserThenActionHelper = alertUserThenActionHelper;
    }

    public Either<ThenActionError, RuleMessage> invoke(@Nonnull ThenAction.ThenActionParam thenActionParam) {
        ApplicationUser user = thenActionParam.getUser();
        Either issueEither = this.issueMessageHelper.getIssue(thenActionParam.getMessage());
        if (issueEither.isLeft()) {
            return this.thenActionErrorHelper.error((AnError)issueEither.left().get());
        }
        Issue issue = (Issue)issueEither.right().get();
        Either userKeysJSONEither = StepsConverters.olderEither(this.alertUserThenActionHelper.getConfiguredUserList(user, thenActionParam.getConfiguration().getData()));
        if (userKeysJSONEither.isLeft()) {
            return Either.left((Object)userKeysJSONEither.left().get());
        }
        List userKeyList = (List)userKeysJSONEither.right().get();
        String alertMessage = this.alertUserThenActionHelper.getAlertMessage(user, userKeyList);
        Either createAlertResult = StepsConverters.olderEither(this.alertUserThenActionHelper.createAlert(user, issue, alertMessage));
        if (createAlertResult.isLeft()) {
            return Either.left((Object)createAlertResult.left().get());
        }
        return Either.right((Object)thenActionParam.getMessage());
    }
}

