/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDUserRoleTypeIfConditionHelper {
    public static final String USER_TYPE_CONFIG_NAME_KEY = "userRoleType";
    @VisibleForTesting
    static final String USER_TYPE_FIELD_NAME = "userRoleType";
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final OutsiderPermissionChecker outsiderPermissionChecker;
    private final ErrorTranslationHelper errorTranslationHelper;

    @Autowired
    public SDUserRoleTypeIfConditionHelper(I18nHelper.BeanFactory i18nFactory, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, IfConditionErrorHelper ifConditionErrorHelper, OutsiderPermissionChecker outsiderPermissionChecker, ErrorTranslationHelper errorTranslationHelper) {
        this.i18nFactory = i18nFactory;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, String> getIfConditionName(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Either<IfConditionError, UserType> expectedTypeEither = this.getExpectedType(user, configurationData);
        if (expectedTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)expectedTypeEither.left().get());
        }
        UserType expectedUserType = (UserType)((Object)expectedTypeEither.right().get());
        if (expectedUserType == UserType.Agent) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.user.type.name.agent"));
        }
        if (expectedUserType == UserType.Customer) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.user.type.name.customer"));
        }
        if (expectedUserType == UserType.NonCustomer) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.user.type.name.non.customer"));
        }
        if (expectedUserType == UserType.NonAgent) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.user.type.name.non.agent"));
        }
        if (expectedUserType == UserType.NoAccess) {
            return io.atlassian.fugue.Either.right((Object)i18nHelper.getText("sd.if.user.type.name.no.access"));
        }
        return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText(i18nHelper.getText("sd.if.user.type.missing"))));
    }

    @Nonnull
    public io.atlassian.fugue.Either<IfConditionError, Boolean> checkUserAgainstExpectedType(@Nonnull ApplicationUser executingUser, @Nonnull ApplicationUser userToCheckAgainst, @Nonnull ConfigurationData configurationData, @Nonnull Issue issue) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"executingUser", (Object)executingUser);
        Assertions.notNull((String)"userToCheckAgainst", (Object)userToCheckAgainst);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(executingUser);
        io.atlassian.fugue.Either<IfConditionError, UserType> expectedTypeEither = this.getExpectedType(executingUser, configurationData);
        if (expectedTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)expectedTypeEither.left().get());
        }
        UserType expectedUserType = (UserType)((Object)expectedTypeEither.right().get());
        if (expectedUserType == UserType.Agent) {
            return this.checkUserIsAgent(executingUser, userToCheckAgainst, issue.getProjectObject());
        }
        if (expectedUserType == UserType.Customer) {
            return this.checkUserIsCustomer(userToCheckAgainst, issue);
        }
        if (expectedUserType == UserType.NonAgent) {
            io.atlassian.fugue.Either<IfConditionError, Boolean> isAgentEither = this.checkUserIsAgent(executingUser, userToCheckAgainst, issue.getProjectObject());
            return this.negateRightBooleanEither(isAgentEither).map(notAgent -> notAgent != false && !this.outsiderPermissionChecker.isUserAnOutsider(userToCheckAgainst, issue));
        }
        if (expectedUserType == UserType.NonCustomer) {
            io.atlassian.fugue.Either<IfConditionError, Boolean> isCustomerEither = this.checkUserIsCustomer(userToCheckAgainst, issue);
            return this.negateRightBooleanEither(isCustomerEither).map(notCustomer -> notCustomer != false && !this.outsiderPermissionChecker.isUserAnOutsider(userToCheckAgainst, issue));
        }
        if (expectedUserType == UserType.NoAccess) {
            return this.checkUserIsOutsider(userToCheckAgainst, issue);
        }
        return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText(i18nHelper.getText("sd.if.user.type.invalid"))));
    }

    @Nonnull
    public ValidationResult isValidParam(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Assertions.notNull((String)"user", (Object)user);
        io.atlassian.fugue.Either<IfConditionError, UserType> expectedType = this.getExpectedType(user, configurationData);
        if (expectedType.isLeft()) {
            String message = ((IfConditionError)expectedType.left().get()).getMessage().getMessage();
            return this.createFieldError(user, message);
        }
        UserType userType = (UserType)((Object)expectedType.right().get());
        if (userType == UserType.NoAccess) {
            return this.checkNoAccessFeatureValid();
        }
        return ValidationResult.PASSED();
    }

    @VisibleForTesting
    ValidationResult checkNoAccessFeatureValid() {
        return (ValidationResult)this.outsiderPermissionChecker.checkFeatureEnabled().fold(anError -> {
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("userRoleType", Lists.newArrayList((Object[])new String[]{this.errorTranslationHelper.translateAnError(anError)}));
            return ValidationResult.FAILED((Map)errorMap);
        }, unit -> ValidationResult.PASSED());
    }

    @Nonnull
    private ValidationResult createFieldError(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        HashMap errorList = Maps.newHashMap();
        errorList.put("userRoleType", Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)}));
        return ValidationResult.FAILED((Map)errorList);
    }

    private io.atlassian.fugue.Either<IfConditionError, Boolean> checkUserIsCustomer(@Nonnull ApplicationUser userToCheck, @Nonnull Issue issue) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isCustomer(userToCheck, issue)).leftMap(error -> (IfConditionError)this.ifConditionErrorHelper.error(error).left().get());
    }

    private io.atlassian.fugue.Either<IfConditionError, Boolean> checkUserIsOutsider(@Nonnull ApplicationUser userToCheck, @Nonnull Issue issue) {
        return this.outsiderPermissionChecker.isUserAnOutsiderEither(userToCheck, issue).leftMap(error -> (IfConditionError)this.ifConditionErrorHelper.error(error).left().get());
    }

    private io.atlassian.fugue.Either<IfConditionError, Boolean> checkUserIsAgent(@Nonnull ApplicationUser executingUser, @Nonnull ApplicationUser userToCheck, Project project) {
        io.atlassian.fugue.Either serviceDeskForProjectEither = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(executingUser, project));
        if (serviceDeskForProjectEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error((AnError)serviceDeskForProjectEither.left().get()));
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskForProjectEither.right().get();
        io.atlassian.fugue.Either isAgentEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(userToCheck, serviceDesk));
        if (isAgentEither.isLeft()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error((AnError)isAgentEither.left().get()));
        }
        Boolean isAgent = (Boolean)isAgentEither.right().get();
        return io.atlassian.fugue.Either.right((Object)isAgent);
    }

    private io.atlassian.fugue.Either<IfConditionError, Boolean> negateRightBooleanEither(@Nonnull io.atlassian.fugue.Either<IfConditionError, Boolean> currentEitherResult) {
        return currentEitherResult.map(BooleanUtils::negate);
    }

    @Nonnull
    private io.atlassian.fugue.Either<IfConditionError, UserType> getExpectedType(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        io.atlassian.fugue.Option userTypeConfigOption = StepsConverters.newerOption((Option)configurationData.getValue("userRoleType"));
        if (userTypeConfigOption.isEmpty() || StringUtils.isBlank((String)((String)userTypeConfigOption.get()))) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText(i18nHelper.getText("sd.if.user.type.missing"))));
        }
        String userType = (String)userTypeConfigOption.get();
        io.atlassian.fugue.Option<UserType> userTypeOption = UserType.getUserType(userType);
        if (userTypeOption.isEmpty()) {
            return StepsConverters.newerEither((Either)this.ifConditionErrorHelper.error(i18nHelper.getText("sd.if.user.type.invalid")));
        }
        return io.atlassian.fugue.Either.right((Object)userTypeOption.get());
    }

    private static enum UserType {
        Customer("customer"),
        Agent("agent"),
        NonCustomer("non_customer"),
        NonAgent("non_agent"),
        NoAccess("no_access");

        private final String userType;

        private UserType(String s) {
            this.userType = s;
        }

        private boolean equalsUserType(String other) {
            return other != null && other.equals(this.userType);
        }

        public String toString() {
            return this.userType;
        }

        public static io.atlassian.fugue.Option<UserType> getUserType(String userType) {
            ArrayList values = Lists.newArrayList((Object[])UserType.values());
            return Iterables.findFirst((Iterable)values, input -> input.equalsUserType(userType));
        }
    }
}

