/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.SDUserRoleTypeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@Nonnull
public class SDUserRoleTypeIfCondition
implements IfCondition {
    private final SDUserRoleTypeIfConditionHelper sdUserRoleTypeIfConditionHelper;
    private final UserMessageHelper userMessageHelper;
    private final IssueMessageHelper issueMessageHelper;
    private final IfConditionErrorHelper ifConditionErrorHelper;

    @Autowired
    public SDUserRoleTypeIfCondition(SDUserRoleTypeIfConditionHelper sdUserRoleTypeIfConditionHelper, UserMessageHelper userMessageHelper, IssueMessageHelper issueMessageHelper, IfConditionErrorHelper ifConditionErrorHelper) {
        this.sdUserRoleTypeIfConditionHelper = sdUserRoleTypeIfConditionHelper;
        this.userMessageHelper = userMessageHelper;
        this.issueMessageHelper = issueMessageHelper;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        ApplicationUser executingUser = ifConditionParam.getUser();
        Either userEither = this.userMessageHelper.getUser(ifConditionParam.getMessage(), "currentUser");
        if (userEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)userEither.left().get());
        }
        ApplicationUser currentUser = (ApplicationUser)userEither.right().get();
        Either issueEither = this.issueMessageHelper.getIssue(ifConditionParam.getMessage());
        if (issueEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)issueEither.left().get());
        }
        Issue issue = (Issue)issueEither.right().get();
        Either isMatchEither = StepsConverters.olderEither(this.sdUserRoleTypeIfConditionHelper.checkUserAgainstExpectedType(executingUser, currentUser, ifConditionParam.getConfiguration().getData(), issue));
        return isMatchEither;
    }
}

