/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.CommentMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.SDCommentVisibilityIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@Nonnull
public class SDCommentVisibilityIfCondition
implements IfCondition {
    private final SDCommentVisibilityIfConditionHelper sdCommentVisibilityIfConditionHelper;
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final CommentMessageHelper commentMessageHelper;

    @Autowired
    public SDCommentVisibilityIfCondition(SDCommentVisibilityIfConditionHelper sdCommentVisibilityIfConditionHelper, IfConditionErrorHelper ifConditionErrorHelper, CommentMessageHelper commentMessageHelper) {
        this.sdCommentVisibilityIfConditionHelper = sdCommentVisibilityIfConditionHelper;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.commentMessageHelper = commentMessageHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        ApplicationUser user = ifConditionParam.getUser();
        Either commentEither = this.commentMessageHelper.getComment(ifConditionParam.getMessage());
        if (commentEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)commentEither.left().get());
        }
        Comment comment = (Comment)commentEither.right().get();
        Either isCommentVisibilityExpectedType = StepsConverters.olderEither(this.sdCommentVisibilityIfConditionHelper.checkCommentMatchConfiguration(user, comment, ifConditionParam.getConfiguration().getData()));
        return isCommentVisibilityExpectedType;
    }
}

