/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.modules.common.LinkTypeDirection;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.LinkTypeIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class LinkTypeIfCondition
implements IfCondition {
    private final IfConditionErrorHelper ifConditionErrorHelper;
    private final LinkTypeIfConditionHelper linkTypeHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public LinkTypeIfCondition(@Nonnull IfConditionErrorHelper ifConditionErrorHelper, @Nonnull LinkTypeIfConditionHelper linkTypeHelper, @Nonnull I18nHelper i18nHelper) {
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.linkTypeHelper = linkTypeHelper;
        this.i18nHelper = i18nHelper;
    }

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        RuleMessage message = ifConditionParam.getMessage();
        Option linkTypesOpt = StepsConverters.olderOption(this.linkTypeHelper.getLinkTypeData(message));
        if (!linkTypesOpt.isDefined()) {
            return this.ifConditionErrorHelper.error(this.i18nHelper.getText("sd.if.issue.linktype.not.found"));
        }
        Map linkTypes = (Map)linkTypesOpt.get();
        ConfigurationData configurationData = ifConditionParam.getConfiguration().getData();
        Either linkTypeIdEither = StepsConverters.olderEither(this.linkTypeHelper.getLinkTypeId(configurationData));
        if (linkTypeIdEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)linkTypeIdEither.left().get());
        }
        String linkTypeId = (String)linkTypeIdEither.right().get();
        Either linkTypeDirectionEither = StepsConverters.olderEither(this.linkTypeHelper.getLinkTypeDirection(configurationData));
        if (linkTypeDirectionEither.isLeft()) {
            return this.ifConditionErrorHelper.error((AnError)linkTypeDirectionEither.left().get());
        }
        LinkTypeDirection linkTypeDirection = (LinkTypeDirection)((Object)linkTypeDirectionEither.right().get());
        return this.matchLinkType(linkTypes, linkTypeId, linkTypeDirection);
    }

    @VisibleForTesting
    Either<IfConditionError, Boolean> matchLinkType(@Nonnull Map<IssueLinkType, List<LinkTypeDirection>> incidentLinkTypes, @Nonnull String matchingLinkTypeId, @Nonnull LinkTypeDirection matchingLinkTypeDirection) {
        for (Map.Entry<IssueLinkType, List<LinkTypeDirection>> entry : incidentLinkTypes.entrySet()) {
            IssueLinkType linkType = entry.getKey();
            String inward = linkType.getInward();
            String outward = linkType.getOutward();
            String linkTypeId = linkType.getId().toString();
            if (Objects.equals(inward, outward)) {
                if (!Objects.equals(matchingLinkTypeId, linkTypeId)) continue;
                return Either.right((Object)true);
            }
            List<LinkTypeDirection> incidentDirections = entry.getValue();
            Assertions.notNull((String)"incidentDirections", incidentDirections);
            LinkTypeDirection reversedMatchingLinkTypeDirection = matchingLinkTypeDirection.reverse();
            if (!Objects.equals(matchingLinkTypeId, linkTypeId) || !incidentDirections.contains((Object)reversedMatchingLinkTypeDirection)) continue;
            return Either.right((Object)true);
        }
        return Either.right((Object)false);
    }
}

