/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class IssueResolutionChangedIfConditionHelper {
    private static final String FIELD_CHANGE_TYPE_CONFIG_KEY = "fieldChangeType";
    private static final String FIELD_CHANGE_TYPE_MISSING_I18N_KEY = "sd.if.resolution.changed.expected.field.change.type.missing";
    private final I18nHelper.BeanFactory i18nFactory;
    private final IfConditionErrorHelper ifConditionErrorHelper;

    @Autowired
    public IssueResolutionChangedIfConditionHelper(I18nHelper.BeanFactory i18nFactory, IfConditionErrorHelper ifConditionErrorHelper) {
        this.i18nFactory = i18nFactory;
        this.ifConditionErrorHelper = ifConditionErrorHelper;
    }

    @Nonnull
    public Option<FieldChangeType> retrieveChangeTypeConfiguration(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        ConfigurationData data = ifConditionParam.getConfiguration().getData();
        Option resolutionChangeOption = data.getValue(FIELD_CHANGE_TYPE_CONFIG_KEY);
        return resolutionChangeOption.flatMap(this::retrieveFieldChangeType);
    }

    public ValidationResult validateConfiguration(ApplicationUser userToValidateWith, ConfigurationData configurationData) {
        Assertions.notNull((String)"userToValidateWith", (Object)userToValidateWith);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Either<IfConditionError, FieldChangeType> fieldChangeTypeEither = this.retrieveFieldChangeType(userToValidateWith, configurationData);
        return (ValidationResult)fieldChangeTypeEither.fold(error -> this.createFieldError(userToValidateWith, FIELD_CHANGE_TYPE_MISSING_I18N_KEY), success -> ValidationResult.PASSED());
    }

    @Nonnull
    public Either<IfConditionError, String> getNameForConfiguration(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"configurationData", (Object)configurationData);
        Either<IfConditionError, FieldChangeType> fieldChangeTypeEither = this.retrieveFieldChangeType(user, configurationData);
        return (Either)fieldChangeTypeEither.fold(Either::left, fieldChangeType -> this.retrieveNameFromChangeType(user, (FieldChangeType)fieldChangeType));
    }

    private Either<IfConditionError, String> retrieveNameFromChangeType(ApplicationUser user, FieldChangeType fieldChangeTypeEither) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        switch (fieldChangeTypeEither) {
            case SET: {
                return Either.right((Object)i18nHelper.getText("sd.if.resolution.changed.set"));
            }
            case CLEAR: {
                return Either.right((Object)i18nHelper.getText("sd.if.resolution.changed.cleared"));
            }
        }
        return this.ifConditionErrorHelper.error(i18nHelper.getText(FIELD_CHANGE_TYPE_MISSING_I18N_KEY));
    }

    @Nonnull
    private Either<IfConditionError, FieldChangeType> retrieveFieldChangeType(@Nonnull ApplicationUser user, @Nonnull ConfigurationData configurationData) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        Option fieldChangeType = configurationData.getValue(FIELD_CHANGE_TYPE_CONFIG_KEY).flatMap(this::retrieveFieldChangeType);
        if (fieldChangeType.isEmpty() || fieldChangeType.exists(value -> value != FieldChangeType.SET && value != FieldChangeType.CLEAR)) {
            return this.ifConditionErrorHelper.error(i18nHelper.getText(FIELD_CHANGE_TYPE_MISSING_I18N_KEY));
        }
        return Either.right((Object)fieldChangeType.get());
    }

    private Option<FieldChangeType> retrieveFieldChangeType(String fieldChangeTypeString) {
        try {
            return Option.some((Object)FieldChangeType.valueOf((String)fieldChangeTypeString));
        }
        catch (IllegalArgumentException e) {
            return Option.none();
        }
    }

    @Nonnull
    private ValidationResult createFieldError(@Nonnull ApplicationUser user, @Nonnull String i18nKey) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        HashMap errorList = Maps.newHashMap();
        errorList.put(FIELD_CHANGE_TYPE_CONFIG_KEY, Lists.newArrayList((Object[])new String[]{i18nHelper.getText(i18nKey)}));
        return ValidationResult.FAILED((Map)errorList);
    }
}

