/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueJqlIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IssueJqlIfConditionValidator
implements IfConditionValidator {
    private final IssueJqlIfConditionHelper issueJqlIfConditionHelper;

    @Autowired
    public IssueJqlIfConditionValidator(IssueJqlIfConditionHelper issueJqlIfConditionHelper) {
        this.issueJqlIfConditionHelper = issueJqlIfConditionHelper;
    }

    public ValidationResult validate(@Nonnull IfConditionValidator.IfConditionValidationParam ifConditionValidationParam) {
        IfConditionConfiguration configuration = ifConditionValidationParam.getConfiguration();
        Either<IfConditionError, String> jqlEither = this.issueJqlIfConditionHelper.getJql(configuration.getData());
        if (jqlEither.isLeft()) {
            return this.issueJqlIfConditionHelper.getValidationResultFromError("sd.if.jql.missing.jql");
        }
        String jql = (String)jqlEither.right().get();
        if (StringUtils.isBlank((String)jql)) {
            return ValidationResult.PASSED();
        }
        ApplicationUser userToValidateWith = ifConditionValidationParam.getUserToValidateWith();
        List<String> jqlQueryValidationError = this.issueJqlIfConditionHelper.validationJql(userToValidateWith, jql);
        if (!jqlQueryValidationError.isEmpty()) {
            return this.issueJqlIfConditionHelper.getValidationResultFromError(jqlQueryValidationError);
        }
        return ValidationResult.PASSED();
    }
}

