/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CommentStringMatcherIfConditionValidator
implements IfConditionValidator {
    private static final String COMMENT_FIELD_NAME = "comment";
    private final I18nHelper i18nHelper;

    @Autowired
    public CommentStringMatcherIfConditionValidator(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public ValidationResult validate(@Nonnull IfConditionValidator.IfConditionValidationParam ifConditionValidationParam) {
        Assertions.notNull((String)"ifConditionValidationParam", (Object)ifConditionValidationParam);
        Option matchStringOption = ifConditionValidationParam.getConfiguration().getData().getValue("matchString");
        if (matchStringOption.isDefined() && !StringUtils.isBlank((String)((String)matchStringOption.get()))) {
            return ValidationResult.PASSED();
        }
        HashMap fieldErrors = Maps.newHashMap();
        fieldErrors.put(COMMENT_FIELD_NAME, Lists.newArrayList((Object[])new String[]{this.i18nHelper.getText("sd.if.comment.string.matcher.empty.comment")}));
        return ValidationResult.FAILED((Map)fieldErrors);
    }
}

