/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueJqlIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.visualiser.RuleComponentVisualiser;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractIssueJqlIfConditionVisualiser
implements RuleComponentVisualiser {
    protected final I18nHelper i18nHelper;
    protected final IssueJqlIfConditionHelper issueJqlIfConditionHelper;

    @Autowired
    public AbstractIssueJqlIfConditionVisualiser(@Nonnull I18nHelper i18nHelper, @Nonnull IssueJqlIfConditionHelper issueJqlIfConditionHelper) {
        this.issueJqlIfConditionHelper = issueJqlIfConditionHelper;
        this.i18nHelper = i18nHelper;
    }

    @Nonnull
    public Option<String> getLabel(@Nonnull RuleComponentVisualiser.RuleComponentVisualiserParam ruleComponentVisualiserParam) {
        Either jqlEither = StepsConverters.olderEither(this.issueJqlIfConditionHelper.getJql(ruleComponentVisualiserParam.ruleConfiguration()));
        if (jqlEither.isRight()) {
            String jql = (String)jqlEither.right().get();
            if (StringUtils.isBlank((String)jql)) {
                return Option.some((Object)this.i18nHelper.getText("sd.if.jql.status.label.all.issues"));
            }
            return Option.some((Object)this.i18nHelper.getText("sd.if.jql.status.label", jql));
        }
        return Option.some((Object)this.i18nHelper.getText("sd.component.missing.configuration.error"));
    }
}

