/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.ruleif;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionErrorHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.modules.ruleif.IssueJqlIfConditionHelper;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractIssueJqlIfCondition
implements IfCondition {
    protected final SearchProvider searchProvider;
    protected final IfConditionErrorHelper ifConditionErrorHelper;
    protected final IssueJqlIfConditionHelper issueJqlIfConditionHelper;
    protected final FeatureManager featureManager;

    @Autowired
    public AbstractIssueJqlIfCondition(@Nonnull SearchProvider searchProvider, @Nonnull IfConditionErrorHelper ifConditionErrorHelper, @Nonnull IssueJqlIfConditionHelper issueJqlIfConditionHelper, @Nonnull FeatureManager featureManager) {
        this.ifConditionErrorHelper = ifConditionErrorHelper;
        this.searchProvider = searchProvider;
        this.issueJqlIfConditionHelper = issueJqlIfConditionHelper;
        this.featureManager = featureManager;
    }

    protected abstract Either<AnError, Issue> getIssue(RuleMessage var1);

    public Either<IfConditionError, Boolean> matches(@Nonnull IfCondition.IfConditionParam ifConditionParam) {
        block7: {
            Either<AnError, Issue> issueEither = this.getIssue(ifConditionParam.getMessage());
            if (issueEither.isLeft()) {
                return this.ifConditionErrorHelper.error((AnError)issueEither.left().get());
            }
            Issue issue = (Issue)issueEither.right().get();
            try {
                Either<IfConditionError, Query> queryEither = this.getJqlQuery(ifConditionParam.getConfiguration(), ifConditionParam.getMessage());
                if (queryEither.isRight()) {
                    Query query = (Query)queryEither.right().get();
                    if (StringUtils.isBlank((String)query.getQueryString())) {
                        return Either.right((Object)true);
                    }
                    JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder((Query)query);
                    query = jqlQueryBuilder.where().and().issue(new String[]{issue.getKey()}).buildQuery();
                    SearchResults searchResults = this.searchProvider.search(query, ifConditionParam.getUser(), PagerFilter.getUnlimitedFilter());
                    if (searchResults != null && !searchResults.getIssues().isEmpty()) {
                        return Either.right((Object)true);
                    }
                    break block7;
                }
                return Either.left((Object)queryEither.left().get());
            }
            catch (JqlParseException parseException) {
                return StepsConverters.olderEither(this.issueJqlIfConditionHelper.getParseExceptionError(parseException));
            }
            catch (SearchException searchException) {
                return StepsConverters.olderEither(this.issueJqlIfConditionHelper.getSearchExceptionError(searchException));
            }
        }
        return Either.right((Object)false);
    }

    @Nonnull
    protected Either<IfConditionError, Query> getJqlQuery(@Nonnull IfConditionConfiguration ruleConfiguration, @Nonnull RuleMessage message) throws JqlParseException {
        Either jqlEither = StepsConverters.olderEither(this.issueJqlIfConditionHelper.getJql(ruleConfiguration.getData()));
        if (jqlEither.isLeft()) {
            return Either.left((Object)jqlEither.left().get());
        }
        String jql = (String)jqlEither.right().get();
        return StepsConverters.olderEither(this.issueJqlIfConditionHelper.parseJql(jql));
    }
}

