/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen;

import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.RequestTypeListResponse;
import com.atlassian.servicedesk.plugins.automation.modules.rest.rulethen.RequestTypeResponse;
import com.atlassian.servicedesk.plugins.automation.modules.service.request.requesttype.AutomationRequestTypeService;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/then/requesttype")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RequestTypeRestResource {
    private final AutomationRequestTypeService requestTypeService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;

    public RequestTypeRestResource(@Nonnull UserFactory userFactory, @Nonnull AutomationRequestTypeService requestTypeService, @Nonnull RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.requestTypeService = requestTypeService;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="{projectKey}/requesttypes")
    public Response getRequestTypes(@PathParam(value="projectKey") String projectKey) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        Either result = this.requestTypeService.getRequestTypes(user.forJIRA(), projectKey).map(this::convertToResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private RequestTypeListResponse convertToResponse(List<RequestType> requestTypes) {
        return new RequestTypeListResponse(requestTypes.stream().map(requestType -> new RequestTypeResponse(requestType.getId(), requestType.getName())).collect(Collectors.toList()));
    }
}

