/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.permission;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.modules.permission.AutomationJiraPermissionChecker;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class AutomationJiraPermissionCheckerImpl
implements AutomationJiraPermissionChecker {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;

    @Autowired
    public AutomationJiraPermissionCheckerImpl(GlobalPermissionManager globalPermissionManager, PermissionManager permissionManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean hasProjectAdminPermission(@Nullable ApplicationUser user) {
        if (user == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.permissionManager.hasProjects(ProjectPermissions.ADMINISTER_PROJECTS, user);
    }

    @Override
    public boolean hasProjectAdminOrGlobalAdminPermission(@Nullable ApplicationUser user) {
        if (user == null) {
            return false;
        }
        return this.permissionManager.hasProjects(ProjectPermissions.ADMINISTER_PROJECTS, user) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

