/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.atlassian.fugue.Option;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class OrganisationParticipantsMessageHelper {
    private static final Logger log = LoggerFactory.getLogger(OrganisationParticipantsMessageHelper.class);
    private static final Gson GSON = new Gson();
    private static final Type GSON_ORGANISATION_PARTICIPANTS_SET_TYPE = new TypeToken<Set<Integer>>(){}.getType();
    @VisibleForTesting
    public static final String NEW_ORGANISATION_PARTICIPANTS_MESSAGE_KEY = "newOrganisationParticipantsKeys";

    public static void setNewOrganisationParticipants(RuleMessageBuilder ruleMessageBuilder, Set<Integer> newOrganisationIds) {
        String serializedOrganisationsIds = GSON.toJson(newOrganisationIds);
        ruleMessageBuilder.putValue(NEW_ORGANISATION_PARTICIPANTS_MESSAGE_KEY, serializedOrganisationsIds);
    }

    public static Option<Set<Integer>> getNewOrganisationParticipants(RuleMessage ruleMessage) {
        return StepsConverters.newerOption((com.atlassian.fugue.Option)ruleMessage.getValue(NEW_ORGANISATION_PARTICIPANTS_MESSAGE_KEY)).flatMap(OrganisationParticipantsMessageHelper::deserializeJsonSet);
    }

    private static Option<Set<Integer>> deserializeJsonSet(String serializedSet) {
        try {
            return Option.option((Object)GSON.fromJson(serializedSet, GSON_ORGANISATION_PARTICIPANTS_SET_TYPE));
        }
        catch (JsonSyntaxException e) {
            log.error("Could not parse string set '" + serializedSet + "'. Ensure that the value was properly added to the RuleMessage in the corresponding WHEN handler");
            return Option.none();
        }
    }
}

