/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.event.provider;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.modules.event.SDLinkedIssueEventHelper;
import com.atlassian.servicedesk.plugins.automation.modules.event.SDLinkedIssueTransitionedEventImpl;
import com.atlassian.servicedesk.plugins.automation.modules.event.provider.SDLinkedIssueEventProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class SDLinkedIssueEventProviderImpl
implements SDLinkedIssueEventProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SDLinkedIssueEventProviderImpl.class);
    private final IssueLinkManager issueLinkManager;
    private final EventPublisher eventPublisher;
    private final SDLinkedIssueEventHelper linkedIssueEventHelper;

    @Autowired
    public SDLinkedIssueEventProviderImpl(IssueLinkManager issueLinkManager, EventPublisher eventPublisher, SDLinkedIssueEventHelper linkedIssueEventHelper) {
        this.issueLinkManager = issueLinkManager;
        this.eventPublisher = eventPublisher;
        this.linkedIssueEventHelper = linkedIssueEventHelper;
    }

    @Override
    @EventListener
    public void onIssueChangedEvent(IssueChangedEvent issueChangedEvent) {
        Issue sourceIssue = issueChangedEvent.getIssue();
        Long issueId = sourceIssue.getId();
        ApplicationUser eventTriggeredUser = issueChangedEvent.getAuthor().orElse(null);
        List<IssueLink> outwardLinks = this.getFilteredOutwardLinks(issueId);
        List<IssueLink> inwardLinks = this.getFilteredInwardLinks(issueId);
        if (outwardLinks.isEmpty() && inwardLinks.isEmpty()) {
            return;
        }
        this.publishEvent(issueChangedEvent, outwardLinks, inwardLinks, eventTriggeredUser);
    }

    @VisibleForTesting
    void publishEvent(IssueChangedEvent issueChangedEvent, List<IssueLink> outwardLinks, List<IssueLink> inwardLinks, @Nullable ApplicationUser eventTriggeredUser) {
        io.atlassian.fugue.Option changedStatusOpt = io.atlassian.fugue.Option.fromOptional((Optional)issueChangedEvent.getChangeItemForField("status"));
        changedStatusOpt.forEach(changedStatus -> {
            if (this.linkedIssueEventHelper.isTransitionedEvent((ChangeItemBean)changedStatus)) {
                this.publishTransitionedEvent(outwardLinks, inwardLinks, eventTriggeredUser, (ChangeItemBean)changedStatus, this.getComment(issueChangedEvent));
            }
        });
    }

    @VisibleForTesting
    io.atlassian.fugue.Option<Comment> getComment(IssueChangedEvent issueChangedEvent) {
        return io.atlassian.fugue.Option.fromOptional((Optional)issueChangedEvent.getComment());
    }

    @VisibleForTesting
    void publishTransitionedEvent(List<IssueLink> outwardLinks, List<IssueLink> inwardLinks, @Nullable ApplicationUser eventTriggeredUser, ChangeItemBean changedStatus, io.atlassian.fugue.Option<Comment> comment) {
        io.atlassian.fugue.Option<Status> fromOpt = this.linkedIssueEventHelper.getStatus(changedStatus.getFrom());
        if (fromOpt.isEmpty()) {
            LOG.warn("No status found for " + changedStatus.getFromString() + ". Skipping publishing SDLinkedIssueTransitionedEvent.");
            return;
        }
        io.atlassian.fugue.Option<Status> toOpt = this.linkedIssueEventHelper.getStatus(changedStatus.getTo());
        if (toOpt.isEmpty()) {
            LOG.warn("No status found for " + changedStatus.getToString() + ". Skipping publishing SDLinkedIssueTransitionedEvent.");
            return;
        }
        SDLinkedIssueTransitionedEventImpl event = new SDLinkedIssueTransitionedEventImpl(outwardLinks, inwardLinks, eventTriggeredUser, (Status)fromOpt.get(), (Status)toOpt.get(), (Option<Comment>)StepsConverters.olderOption(comment));
        this.eventPublisher.publish((Object)event);
    }

    @VisibleForTesting
    void filterLink(List<IssueLink> filteredLinks, IssueLink issueLink, Issue issue) {
        if (this.linkedIssueEventHelper.isServiceDeskIssue(issue)) {
            filteredLinks.add(issueLink);
        }
    }

    @VisibleForTesting
    List<IssueLink> getFilteredInwardLinks(Long issueId) {
        List inwardLinks = this.issueLinkManager.getInwardLinks(issueId);
        ArrayList filteredInwardLinks = Lists.newArrayList();
        for (IssueLink inwardLink : inwardLinks) {
            Issue sourceIssue = inwardLink.getSourceObject();
            if (issueId.equals(sourceIssue.getId())) continue;
            this.filterLink(filteredInwardLinks, inwardLink, sourceIssue);
        }
        return ImmutableList.copyOf((Collection)filteredInwardLinks);
    }

    @VisibleForTesting
    List<IssueLink> getFilteredOutwardLinks(Long issueId) {
        List outwardLinks = this.issueLinkManager.getOutwardLinks(issueId);
        ArrayList filteredOutwardLinks = Lists.newArrayList();
        for (IssueLink outwardLink : outwardLinks) {
            Issue destinationIssue = outwardLink.getDestinationObject();
            if (issueId.equals(destinationIssue.getId())) continue;
            this.filterLink(filteredOutwardLinks, outwardLink, destinationIssue);
        }
        return ImmutableList.copyOf((Collection)filteredOutwardLinks);
    }
}

