/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.common;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.util.ImportUtils;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueIndexingHelper {
    private final IssueIndexManager issueIndexManager;
    private final IssueIndexingService issueIndexingService;
    private final Effect<IndexingContext> resetIndexingContextEffect;
    private static final Logger LOG = LoggerFactory.getLogger(IssueIndexingHelper.class);

    @Autowired
    public IssueIndexingHelper(IssueIndexManager issueIndexManager, IssueIndexingService issueIndexingService) {
        this.issueIndexManager = issueIndexManager;
        this.issueIndexingService = issueIndexingService;
        this.resetIndexingContextEffect = new Effect<IndexingContext>(){

            public void apply(IndexingContext indexingContext) {
                IssueIndexingHelper.this.resetIndexingToPrevious(indexingContext);
            }
        };
    }

    public void reindexIssue(Issue issue) {
        this.reindexIssue(issue, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexIssue(Issue issue, boolean forceIndexingNow) {
        Option indexingContext = forceIndexingNow ? Option.option((Object)this.activateIndexing()) : Option.none();
        try {
            this.issueIndexingService.reIndex(issue);
        }
        catch (IndexException e) {
            LOG.error("Error reindexing issue prior to rule processing. This should not prevent Automation Engine working", (Throwable)e);
        }
        finally {
            indexingContext.foreach(this.resetIndexingContextEffect);
        }
    }

    public IndexingContext activateIndexing() {
        IndexingContext context = new IndexingContext();
        context.isIndexIssues = ImportUtils.isIndexIssues();
        context.isHeld = this.issueIndexManager.isHeld();
        if (!context.isIndexIssues) {
            ImportUtils.setIndexIssues((boolean)true);
        }
        if (context.isHeld) {
            try {
                this.issueIndexManager.release();
            }
            catch (IndexException e) {
                LOG.error("Error reactivating indexing %s", (Object)e.getMessage());
            }
        }
        return context;
    }

    public void resetIndexingToPrevious(IndexingContext aIndexingContext) {
        if (aIndexingContext == null) {
            return;
        }
        if (aIndexingContext.isHeld) {
            this.issueIndexManager.hold();
        }
        ImportUtils.setIndexIssues((boolean)aIndexingContext.isIndexIssues);
    }

    public static class IndexingContext {
        public boolean isIndexIssues;
        public boolean isHeld;
    }
}

