/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.blueprint;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.modules.common.CommentType;
import com.atlassian.servicedesk.plugins.automation.modules.func.Functor;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import java.util.List;
import javax.annotation.Nonnull;

public class UpdateOnTransitionBlueprint
implements Blueprint {
    private final BuilderService builderService;
    private final GlobalPropertyDao globalPropertyDao;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ErrorResultHelper errorResultHelper;

    public UpdateOnTransitionBlueprint(BuilderService builderService, GlobalPropertyDao globalPropertyDao, IssueLinkTypeManager issueLinkTypeManager, ErrorResultHelper errorResultHelper, I18nHelper.BeanFactory i18nFactory) {
        this.builderService = builderService;
        this.globalPropertyDao = globalPropertyDao;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.errorResultHelper = errorResultHelper;
        this.i18nFactory = i18nFactory;
    }

    public Either<AnError, RuleSetInput> generateRuleSetInput(@Nonnull Blueprint.BlueprintParam blueprintParam) {
        List projects = blueprintParam.getProjectContext().getProjects();
        if (projects.isEmpty()) {
            return this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.blueprint.error.missing.project", new Object[0]);
        }
        Project project = (Project)projects.get(0);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(blueprintParam.getUser());
        Option linkType = Option.option((Object)this.globalPropertyDao.getLongProperty("servicedesk-automation-special-link-type")).flatMap(id -> Option.option((Object)this.issueLinkTypeManager.getIssueLinkType(id)));
        return Functor.from(() -> ((BuilderService)this.builderService).newRuleSetBuilder()).map(builder -> UpdateOnTransitionBlueprint.addMetaData(builder, project, i18nHelper).rule()).map(builder -> UpdateOnTransitionBlueprint.addWhenClause(builder).ifThen()).map(builder -> this.addIfClauses((RuleSetInputBuilder.IfThenBuilder)builder, (Option<IssueLinkType>)linkType, i18nHelper)).map(builder -> this.addThenClause((RuleSetInputBuilder.IfThenBuilder)builder, i18nHelper).endIfThen().endRule().build()).getAsOldRight();
    }

    private static RuleSetInputBuilder addMetaData(RuleSetInputBuilder ruleSetInputBuilder, Project project, I18nHelper i18nHelper) {
        return ruleSetInputBuilder.name(i18nHelper.getText("sd.automation.default.incident.update.name")).description(i18nHelper.getText("sd.automation.default.incident.update.description")).metadata().projectContext().project(project).endProjectContext().triggerFromOtherRules(Boolean.valueOf(true)).endMetadata();
    }

    private static RuleSetInputBuilder.RuleBuilder addWhenClause(RuleSetInputBuilder.RuleBuilder ruleBuilder) {
        return ruleBuilder.when().whenHandler().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:linked-issue-when-handler").data(null).endWhenHandler().endWhen();
    }

    private RuleSetInputBuilder.IfThenBuilder addIfClauses(RuleSetInputBuilder.IfThenBuilder ifThenBuilder, Option<IssueLinkType> linkType, I18nHelper i18nHelper) {
        RuleSetInputBuilder.IfBuilder firstClause = ifThenBuilder.ruleIf().ifCondition().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:linked-issue-jql-if-condition").data(this.builderService.newConfigurationDataBuilder().put("jql", "Resolution is not empty").build()).endIfCondition();
        return linkType.isDefined() ? firstClause.ifCondition().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:link-type-if-condition").data(this.builderService.newConfigurationDataBuilder().put("linkTypeId", ((IssueLinkType)linkType.get()).getId().toString()).put("linkTypeName", ((IssueLinkType)linkType.get()).getInward()).put("linkTypeDirection", "inward").build()).endIfCondition().endIf() : firstClause.endIf();
    }

    private RuleSetInputBuilder.IfThenBuilder addThenClause(RuleSetInputBuilder.IfThenBuilder ifthenBuilder, I18nHelper i18nHelper) {
        return ifthenBuilder.ruleThen().thenAction().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-comment-action").data(this.builderService.newConfigurationDataBuilder().put("comment", i18nHelper.getText("sd.automation.blueprint.incident.update.then.action.default.comment")).put("commentType", CommentType.Internal.toString()).put("includeLinkedIssueDetails", Boolean.TRUE.toString()).build()).endThenAction().endThen();
    }
}

