/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalPermissionChecker;
import com.atlassian.servicedesk.plugins.approvals.internal.util.SDWorkflowTransitionConditionUtil;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.BlockInProgressApprovalCondition;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.WorkflowConditionDescriptorFactory;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationUpdateOptions;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalConfigurationServiceImpl
implements WorkflowApprovalConfigurationService {
    private final WorkflowApprovalConfigurationManager configurationManager;
    private final ApprovalPermissionChecker permissionService;
    private final WorkflowHelper workflowHelper;
    private final SDWorkflowTransitionConditionUtil sdWorkflowTransitionConditionUtil;
    private final ApprovalError approvalError;

    @Autowired
    public WorkflowApprovalConfigurationServiceImpl(WorkflowApprovalConfigurationManager configurationManager, ApprovalPermissionChecker permissionService, WorkflowHelper workflowHelper, SDWorkflowTransitionConditionUtil sdWorkflowTransitionConditionUtil, ApprovalError approvalError) {
        this.configurationManager = configurationManager;
        this.permissionService = permissionService;
        this.workflowHelper = workflowHelper;
        this.sdWorkflowTransitionConditionUtil = sdWorkflowTransitionConditionUtil;
        this.approvalError = approvalError;
    }

    @Override
    public Either<AnError, Option<WorkflowApprovalConfiguration>> getConfiguration(ApplicationUser user, JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        return Steps.begin(this.permissionService.canConfigureApproval(user, workflow)).yield(checkedUser -> this.configurationManager.getConfiguration(stepDescriptor));
    }

    @Override
    public Either<AnError, List<WorkflowApprovalConfiguration>> getConfigurations(ApplicationUser user, JiraWorkflow workflow) {
        return Steps.begin(this.permissionService.canConfigureApproval(user, workflow)).yield(checkedUser -> this.configurationManager.getConfigurations(workflow));
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> updateConfiguration(ApplicationUser user, JiraWorkflow workflow, StepDescriptor stepDescriptor, WorkflowApprovalConfigurationUpdateOptions updateRequest) {
        return Steps.begin(this.permissionService.canConfigureApproval(user, workflow)).then(checkedUser -> this.deleteConditionsIfActive(user, stepDescriptor, workflow)).then((checkedUser, unit) -> this.configurationManager.updateConfiguration(workflow, stepDescriptor, updateRequest)).then((checkedUser, unit, approvalConfig) -> this.addConditionsIfActive(user, stepDescriptor, workflow)).yield((checkedUser, unit, approvalConfig, unit2) -> approvalConfig);
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> activateConfiguration(ApplicationUser user, JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        return Steps.begin(this.permissionService.canConfigureApproval(user, workflow)).then(checkedUser -> this.deleteConditionsIfActive(user, stepDescriptor, workflow)).then((checkedUser, unit) -> this.configurationManager.activateConfiguration(workflow, stepDescriptor)).then((checkedUser, unit, approvalConfig) -> this.addConditionsIfActive(user, stepDescriptor, workflow)).yield((checkedUser, unit, updatedConfiguration, unit2) -> updatedConfiguration);
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> deactivateConfiguration(ApplicationUser user, JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        return Steps.begin(this.permissionService.canConfigureApproval(user, workflow)).then(checkedUser -> this.deleteConditionsIfActive(user, stepDescriptor, workflow)).then((checkedUser, unit) -> this.configurationManager.deactivateConfiguration(workflow, stepDescriptor)).yield((checkedUser, unit, updatedConfiguration) -> updatedConfiguration);
    }

    private Either<AnError, Unit> addConditionsIfActive(ApplicationUser user, StepDescriptor stepDescriptor, JiraWorkflow workflow) {
        this.getActiveConfiguration(user, workflow, stepDescriptor).map(config -> Steps.begin(this.addApprovalConditionToConfiguredTransitions(workflow.getDescriptor(), stepDescriptor, (WorkflowApprovalConfiguration)config)).then(unit -> this.workflowHelper.saveWorkflow(workflow)).yield((unit, savedWorkflow) -> savedWorkflow));
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, Unit> deleteConditionsIfActive(ApplicationUser user, StepDescriptor stepDescriptor, JiraWorkflow workflow) {
        this.getActiveConfiguration(user, workflow, stepDescriptor).map(config -> Steps.begin(this.removeApprovalConditionFromConfiguredTransitions(workflow.getDescriptor(), stepDescriptor, (WorkflowApprovalConfiguration)config)).then(unit -> this.workflowHelper.saveWorkflow(workflow)).yield((unit, savedWorkflow) -> savedWorkflow));
        return Either.right((Object)Unit.Unit());
    }

    private Option<WorkflowApprovalConfiguration> getActiveConfiguration(ApplicationUser user, JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        Either<AnError, Option<WorkflowApprovalConfiguration>> configuration = this.getConfiguration(user, workflow, stepDescriptor);
        return ((Option)configuration.right().getOrElse((Object)Option.none())).flatMap(config -> config.isActive() ? Option.some((Object)config) : Option.none());
    }

    Either<AnError, Unit> addApprovalConditionToConfiguredTransitions(WorkflowDescriptor workflowDescriptor, StepDescriptor stepDescriptor, WorkflowApprovalConfiguration configuration) {
        ConditionDescriptor condition = WorkflowConditionDescriptorFactory.create(BlockInProgressApprovalCondition.class, Collections.EMPTY_MAP);
        List<ActionDescriptor> allTransitions = this.getAllTransitions(workflowDescriptor, stepDescriptor);
        allTransitions.stream().filter(transition -> this.isApprovalTransition((ActionDescriptor)transition, configuration)).forEach(action -> this.sdWorkflowTransitionConditionUtil.addANDConditionAtTheRootLevel((ActionDescriptor)action, condition));
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, Unit> removeApprovalConditionFromConfiguredTransitions(WorkflowDescriptor workflowDescriptor, StepDescriptor stepDescriptor, WorkflowApprovalConfiguration configuration) {
        Class<BlockInProgressApprovalCondition> conditionType = BlockInProgressApprovalCondition.class;
        List<ActionDescriptor> allTransitions = this.getAllTransitions(workflowDescriptor, stepDescriptor);
        allTransitions.stream().filter(transition -> this.isApprovalTransition((ActionDescriptor)transition, configuration)).forEach(action -> this.sdWorkflowTransitionConditionUtil.deleteRootLevelConditionsByType((ActionDescriptor)action, conditionType));
        return Either.right((Object)Unit.Unit());
    }

    private List<ActionDescriptor> getAllTransitions(WorkflowDescriptor workflowDescriptor, StepDescriptor stepDescriptor) {
        List transitions = stepDescriptor.getActions();
        List globalTransitions = workflowDescriptor.getGlobalActions();
        ArrayList<ActionDescriptor> allTransitions = new ArrayList<ActionDescriptor>();
        allTransitions.addAll(transitions);
        allTransitions.addAll(globalTransitions);
        return allTransitions;
    }

    private boolean isApprovalTransition(ActionDescriptor action, WorkflowApprovalConfiguration config) {
        return String.valueOf(action.getId()).equals(config.getApprovedTransitionId()) || String.valueOf(action.getId()).equals(config.getDeclinedTransitionId());
    }
}

