/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationUpdateOptions;
import com.opensymphony.workflow.loader.StepDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalConfigurationManagerImpl
implements WorkflowApprovalConfigurationManager {
    private static final String JIRA_STATUS_ID = "jira.status.id";
    private static final String APPROVAL_STEP_META_FIELD_ID = "approval.field.id";
    private static final String APPROVAL_STEP_META_CONDITION_TYPE = "approval.condition.type";
    private static final String APPROVAL_STEP_META_CONDITION_VALUE = "approval.condition.value";
    private static final String APPROVAL_STEP_META_APPROVE_TRANSITION_ID = "approval.transition.approved";
    private static final String APPROVAL_STEP_META_REJECT_TRANSITION_ID = "approval.transition.rejected";
    private static final String APPROVAL_STEP_META_IS_ACTIVE = "approval.active";
    private final WorkflowHelper workflowHelper;
    private final WorkflowManager workflowManager;
    private final ApprovalError approvalError;

    @Autowired
    public WorkflowApprovalConfigurationManagerImpl(WorkflowHelper workflowHelper, WorkflowManager workflowManager, ApprovalError approvalError) {
        this.workflowHelper = workflowHelper;
        this.workflowManager = workflowManager;
        this.approvalError = approvalError;
    }

    @Override
    public Option<WorkflowApprovalConfiguration> getConfiguration(StepDescriptor stepDescriptor) {
        Map statusProperties = stepDescriptor.getMetaAttributes();
        if (!statusProperties.containsKey(APPROVAL_STEP_META_FIELD_ID)) {
            return Option.none();
        }
        return Option.some((Object)this.buildApprovalConfiguration(stepDescriptor));
    }

    @Override
    public List<WorkflowApprovalConfiguration> getConfigurations(JiraWorkflow workflow) {
        return this.workflowHelper.getStatusSteps(workflow).stream().flatMap(step -> StreamSupport.stream(this.getConfiguration((StepDescriptor)step).spliterator(), false)).collect(Collectors.toList());
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> updateConfiguration(JiraWorkflow workflow, StepDescriptor stepDescriptor, WorkflowApprovalConfigurationUpdateOptions updateRequest) {
        this.setWorkflowStepProperties(stepDescriptor, updateRequest);
        return this.workflowHelper.saveWorkflow(workflow).map(savedWorkflow -> (WorkflowApprovalConfiguration)this.getConfiguration(stepDescriptor).get());
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> activateConfiguration(JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        return this.updateActive(workflow, stepDescriptor, true).map(this::buildApprovalConfiguration);
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> deactivateConfiguration(JiraWorkflow workflow, StepDescriptor stepDescriptor) {
        return this.updateActive(workflow, stepDescriptor, false).map(this::buildApprovalConfiguration);
    }

    @Override
    public Either<AnError, WorkflowApprovalConfiguration> getActiveConfigurationForIssue(Issue issue) {
        Either approvalConfigurationEither = Steps.begin(this.getWorkflowForIssue(issue)).then(workflow -> this.workflowHelper.getStepByStatusId(workflow, Long.valueOf(issue.getStatusId()).longValue())).then((workflow, stepDescriptor) -> (Either)this.getConfiguration((StepDescriptor)stepDescriptor).fold(() -> Either.left((Object)this.approvalError.APPROVAL_NOT_CONFIGURED()), Either::right)).yield((workflow, stepDescriptor, configuration) -> configuration);
        if (approvalConfigurationEither.isLeft()) {
            return Either.left((Object)approvalConfigurationEither.left().get());
        }
        WorkflowApprovalConfiguration approvalConfiguration = (WorkflowApprovalConfiguration)approvalConfigurationEither.right().get();
        if (!approvalConfiguration.isActive()) {
            return Either.left((Object)this.approvalError.INACTIVE_APPROVAL_CONFIGURATION());
        }
        return Either.right((Object)approvalConfiguration);
    }

    private Either<AnError, JiraWorkflow> getWorkflowForIssue(Issue issue) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue.getProjectId(), issue.getIssueTypeId());
        if (workflow == null) {
            return Either.left((Object)this.approvalError.WORKFLOW_NOT_FOUND());
        }
        return Either.right((Object)workflow);
    }

    private String getPropertyAsString(Map propertySet, String key) {
        return propertySet.getOrDefault(key, "").toString();
    }

    private Either<AnError, StepDescriptor> updateActive(JiraWorkflow workflow, StepDescriptor stepDescriptor, boolean active) {
        Map statusProperties = stepDescriptor.getMetaAttributes();
        statusProperties.put(APPROVAL_STEP_META_IS_ACTIVE, active);
        return this.workflowHelper.saveWorkflow(workflow).map(savedWorkflow -> stepDescriptor);
    }

    private void setWorkflowStepProperties(StepDescriptor stepDescriptor, WorkflowApprovalConfigurationUpdateOptions updateRequest) {
        Map statusProperties = stepDescriptor.getMetaAttributes();
        statusProperties.put(APPROVAL_STEP_META_FIELD_ID, updateRequest.getCustomFieldId());
        statusProperties.put(APPROVAL_STEP_META_CONDITION_TYPE, updateRequest.getConditionType());
        statusProperties.put(APPROVAL_STEP_META_CONDITION_VALUE, updateRequest.getConditionValue());
        statusProperties.put(APPROVAL_STEP_META_REJECT_TRANSITION_ID, updateRequest.getDeclinedTransitionId());
        statusProperties.put(APPROVAL_STEP_META_APPROVE_TRANSITION_ID, updateRequest.getApprovedTransitionId());
    }

    private WorkflowApprovalConfiguration buildApprovalConfiguration(StepDescriptor stepDescriptor) {
        Map statusProperties = stepDescriptor.getMetaAttributes();
        String statusId = this.getPropertyAsString(statusProperties, JIRA_STATUS_ID);
        boolean active = Boolean.parseBoolean(this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_IS_ACTIVE));
        String fieldId = this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_FIELD_ID);
        String conditionType = this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_CONDITION_TYPE);
        String conditionValue = this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_CONDITION_VALUE);
        String approveTransition = this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_APPROVE_TRANSITION_ID);
        String rejectTransition = this.getPropertyAsString(statusProperties, APPROVAL_STEP_META_REJECT_TRANSITION_ID);
        return new WorkflowApprovalConfiguration.Builder().statusId(statusId).isActive(active).customFieldId(fieldId).conditionType(conditionType).conditionValue(conditionValue).approvedTransitionId(approveTransition).declinedTransitionId(rejectTransition).build();
    }
}

