/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.workflow.loader.StepDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalConfigurationHelperImpl
implements WorkflowApprovalConfigurationHelper {
    private final WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager;
    private final ApprovalError approvalError;
    private final WorkflowHelper workflowHelper;
    private final WorkflowManager workflowManager;

    @Autowired
    public WorkflowApprovalConfigurationHelperImpl(WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager, ApprovalError approvalError, WorkflowHelper workflowHelper, WorkflowManager workflowManager) {
        this.workflowApprovalConfigurationManager = workflowApprovalConfigurationManager;
        this.approvalError = approvalError;
        this.workflowHelper = workflowHelper;
        this.workflowManager = workflowManager;
    }

    @Override
    public boolean hasActiveApprovalConfigurationForTransition(ApplicationUser user, StepDescriptor stepDescriptor, int targetTransitionId) {
        Option<WorkflowApprovalConfiguration> configurationOpt = this.workflowApprovalConfigurationManager.getConfiguration(stepDescriptor);
        if (configurationOpt.isEmpty()) {
            return false;
        }
        return this.isTargetTransitionPartOfApprovalConfiguration((WorkflowApprovalConfiguration)configurationOpt.get(), targetTransitionId);
    }

    @Override
    public Either<AnError, Unit> validateApprovalAgainstCurrentStatus(Issue issue, Approval approval) {
        return Steps.begin(this.checkIfApprovalIsInCurrentStatusOfIssue(issue, approval)).then(validApprovalStatus -> this.checkIfStatusHasActiveApprovalConfiguration(issue)).yield((validApprovalStatus, hasActiveApprovalConfig) -> hasActiveApprovalConfig);
    }

    @VisibleForTesting
    Either<AnError, Unit> checkIfApprovalIsInCurrentStatusOfIssue(Issue issue, Approval approval) {
        if (approval.getIssueId() != issue.getId().longValue()) {
            return Either.left((Object)this.approvalError.APPROVAL_NOT_FOUND());
        }
        if (!issue.getStatusId().equals(approval.getStatusId())) {
            return Either.left((Object)this.approvalError.APPROVAL_NOT_BELONG_TO_STATUS());
        }
        return Either.right((Object)Unit.Unit());
    }

    private Either<AnError, Unit> checkIfStatusHasActiveApprovalConfiguration(Issue issue) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
        String currentStatusId = issue.getStatusId();
        return Steps.begin((Either)this.workflowHelper.getStepByStatusId(workflow, Long.valueOf(currentStatusId).longValue())).then(stepDescriptor -> this.hasActiveApprovalConfiguration((StepDescriptor)stepDescriptor)).yield((stepDescriptor, unit) -> unit);
    }

    @VisibleForTesting
    Either<AnError, Unit> hasActiveApprovalConfiguration(StepDescriptor stepDescriptor) {
        Option<WorkflowApprovalConfiguration> approvalConfiguration = this.workflowApprovalConfigurationManager.getConfiguration(stepDescriptor);
        if (approvalConfiguration.isDefined() && ((WorkflowApprovalConfiguration)approvalConfiguration.get()).isActive()) {
            return Either.right((Object)Unit.Unit());
        }
        return Either.left((Object)this.approvalError.APPROVAL_NOT_CONFIGURED());
    }

    private boolean isTargetTransitionPartOfApprovalConfiguration(WorkflowApprovalConfiguration approvalConfiguration, int targetTransitionId) {
        if (!approvalConfiguration.isActive()) {
            return false;
        }
        String approvedTransitionId = approvalConfiguration.getApprovedTransitionId();
        String declinedTransitionId = approvalConfiguration.getDeclinedTransitionId();
        return StringUtils.equals((String)approvedTransitionId, (String)String.valueOf(targetTransitionId)) || StringUtils.equals((String)declinedTransitionId, (String)String.valueOf(targetTransitionId));
    }
}

