/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalCondition;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverTypeConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalEventDispatcher;
import com.atlassian.servicedesk.plugins.approvals.internal.requirement.ApprovalConditionImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.WorkflowApprovalCreationService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowApprovalCreationServiceImpl
implements WorkflowApprovalCreationService {
    private final Logger logger = LoggerFactory.getLogger(WorkflowApprovalCreationService.class);
    private final WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager;
    private final ApprovalManager approvalManager;
    private final InternalApprovalService approvalService;
    private final ApprovalEventDispatcher approvalEventDispatcher;
    private final CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler;

    @Autowired
    public WorkflowApprovalCreationServiceImpl(WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager, ApprovalManager approvalManager, InternalApprovalService approvalService, ApprovalEventDispatcher approvalEventDispatcher, CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler) {
        this.workflowApprovalConfigurationManager = workflowApprovalConfigurationManager;
        this.approvalManager = approvalManager;
        this.approvalService = approvalService;
        this.approvalEventDispatcher = approvalEventDispatcher;
        this.customFieldApproverTypeConfigurationHandler = customFieldApproverTypeConfigurationHandler;
    }

    @Override
    public Option<Approval> handlePotentialApprovalCreation(ApplicationUser user, Issue issue) {
        Either<AnError, WorkflowApprovalConfiguration> configurationEither = this.workflowApprovalConfigurationManager.getActiveConfigurationForIssue(issue);
        if (configurationEither.isLeft()) {
            return Option.none();
        }
        WorkflowApprovalConfiguration configuration = (WorkflowApprovalConfiguration)configurationEither.right().get();
        if (!this.approvalService.hasActiveApprovals(issue)) {
            Either<AnError, Approval> result = this.createApproval(issue, configuration);
            if (result.isLeft()) {
                this.logger.warn(String.format("Failed to create approval for issue id =%s error message: %s ", issue.getId(), ((AnError)result.left().get()).toString()));
            } else {
                this.approvalEventDispatcher.dispatchCreatedApprovalEvent((Approval)result.right().get(), user);
            }
            return result.toOption();
        }
        return Option.none();
    }

    private Either<AnError, Approval> createApproval(Issue issue, WorkflowApprovalConfiguration configuration) {
        return Steps.begin(this.createApprovalParameters(issue, configuration)).then(parameter -> this.approvalManager.createApproval((CreateApprovalParameters)parameter)).yield((parameter, approval) -> approval);
    }

    private Either<AnError, CreateApprovalParameters> createApprovalParameters(Issue issue, WorkflowApprovalConfiguration configuration) {
        Either<AnError, Collection<ApproverConfigurationDataInput>> approverConfigurationDataInputs = this.customFieldApproverTypeConfigurationHandler.toDataInput(configuration.getCustomFieldId());
        if (approverConfigurationDataInputs.isLeft()) {
            return Either.left((Object)approverConfigurationDataInputs.left().get());
        }
        ApprovalConditionImpl approvalCondition = new ApprovalConditionImpl(configuration.getConditionType(), configuration.getConditionValue());
        CreateApprovalParameters createApprovalParameters = this.approvalService.newCreateBuilder().issue(issue).name(issue.getStatus().getName()).statusId(configuration.getStatusId()).approveCondition((ApprovalCondition)approvalCondition).configurationInputs((Collection)approverConfigurationDataInputs.right().get()).build();
        return Either.right((Object)createApprovalParameters);
    }
}

