/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.workflow;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.condition.AbstractJiraCondition;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationHelper;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.spi.SimpleStep;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BlockInProgressApprovalCondition
extends AbstractJiraCondition {
    private final ServiceDeskManager serviceDeskManager;
    private final WorkflowApprovalConfigurationHelper workflowApprovalConfigurationHelper;
    private final InternalApprovalService internalApprovalService;

    @Autowired
    public BlockInProgressApprovalCondition(ServiceDeskManager serviceDeskManager, WorkflowApprovalConfigurationHelper workflowApprovalConfigurationHelper, InternalApprovalService internalApprovalService) {
        this.serviceDeskManager = serviceDeskManager;
        this.workflowApprovalConfigurationHelper = workflowApprovalConfigurationHelper;
        this.internalApprovalService = internalApprovalService;
    }

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        Issue issue = this.getIssue(transientVars);
        ApplicationUser caller = this.getCallerUser(transientVars, args);
        if (issue == null || caller == null) {
            return false;
        }
        if (!this.serviceDeskManager.isServiceDeskProject(issue.getProjectObject())) {
            return true;
        }
        Option<StepDescriptor> currentStep = this.getCurrentStep(transientVars);
        Option<Integer> actionId = this.getActionId(transientVars);
        if (currentStep.isEmpty() || actionId.isEmpty()) {
            return false;
        }
        boolean hasValidActiveApprovalForCurrentStatus = this.internalApprovalService.hasActiveApprovals(issue);
        if (!hasValidActiveApprovalForCurrentStatus) {
            return true;
        }
        boolean hasActiveConfigForTransition = this.workflowApprovalConfigurationHelper.hasActiveApprovalConfigurationForTransition(caller, (StepDescriptor)currentStep.get(), (Integer)actionId.get());
        return !hasActiveConfigForTransition;
    }

    private Option<Integer> getActionId(Map transientVars) {
        return Option.option((Object)((Integer)transientVars.get("actionId")));
    }

    private Option<StepDescriptor> getCurrentStep(Map transientVars) {
        WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)transientVars.get("descriptor");
        List steps = (List)transientVars.get("currentSteps");
        if (workflowDescriptor == null || steps == null || steps.isEmpty()) {
            return Option.none();
        }
        StepDescriptor stepDescriptor = workflowDescriptor.getStep(((SimpleStep)steps.get(0)).getStepId());
        return Option.option((Object)stepDescriptor);
    }
}

