/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view;

import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.internal.api.approver.CustomFieldApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import com.atlassian.servicedesk.internal.api.approver.UserApproverConfiguration;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.InternalApproverDecisionService;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusMapper;
import com.atlassian.servicedesk.internal.api.request.requesttype.status.RequestStatusService;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalCondition;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirementService;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalConditionViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalConfigurationViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalDecisionViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalIssueViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalPortalViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsListIssueViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsListPortalViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApprovalsViewDataHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApproverConfigurationViewData;
import com.atlassian.servicedesk.plugins.approvals.internal.webpanel.view.ApproverDetailedViewData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsViewDataHelperImpl
implements ApprovalsViewDataHelper {
    private final UserManager userManager;
    private final InternalApprovalService approvalService;
    private final InternalApproverService approverService;
    private final InternalApproverDecisionService approverDecisionService;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RequestStatusService requestStatusService;
    private final RequestTypeService requestTypeService;
    private final ApprovalRequirementService approvalRequirementService;

    @Autowired
    public ApprovalsViewDataHelperImpl(UserManager userManager, InternalApprovalService approvalService, InternalApproverService approverService, InternalApproverDecisionService approverDecisionService, AvatarService avatarService, JiraAuthenticationContext jiraAuthenticationContext, RequestStatusService requestStatusService, RequestTypeService requestTypeService, ApprovalRequirementService approvalRequirementService) {
        this.userManager = userManager;
        this.approvalService = approvalService;
        this.approverService = approverService;
        this.approverDecisionService = approverDecisionService;
        this.avatarService = avatarService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.requestStatusService = requestStatusService;
        this.requestTypeService = requestTypeService;
        this.approvalRequirementService = approvalRequirementService;
    }

    @Override
    public ApprovalsListIssueViewData getApprovals(ApplicationUser user, Issue issue) {
        Either approvalsEither = this.approvalService.getApprovals(user, issue);
        ApprovalsListIssueViewData viewData = (ApprovalsListIssueViewData)approvalsEither.fold(error -> new ApprovalsListIssueViewData(Collections.emptyList()), approvals -> new ApprovalsListIssueViewData(this.getIssueViewApprovalsList(user, (Collection)approvalsEither.right().get(), (io.atlassian.fugue.Option<RequestStatusMapper>)io.atlassian.fugue.Option.none())));
        return viewData;
    }

    @Override
    public ApprovalsListPortalViewData getApprovalsForCustomerPortal(ApplicationUser user, Issue issue) {
        Either approvalsEither = this.approvalService.getApprovals(user, issue);
        if (approvalsEither.isLeft()) {
            return new ApprovalsListPortalViewData(Collections.emptyList());
        }
        RequestStatusMapper statusMapper = this.getStatusMapper(user, issue);
        return new ApprovalsListPortalViewData(this.getPortalApprovalsList(user, (Collection)approvalsEither.right().get(), (io.atlassian.fugue.Option<RequestStatusMapper>)io.atlassian.fugue.Option.some((Object)statusMapper)));
    }

    private List<ApprovalIssueViewData> getIssueViewApprovalsList(ApplicationUser user, Collection<Approval> approvals, io.atlassian.fugue.Option<RequestStatusMapper> statusMapper) {
        Comparator byCreatedDate = (a1, a2) -> a2.getCreatedDate().compareTo(a1.getCreatedDate());
        return approvals.stream().sorted(byCreatedDate).map(approval -> this.getApprovalIssueViewData(user, (Approval)approval, statusMapper)).collect(Collectors.toList());
    }

    private List<ApprovalPortalViewData> getPortalApprovalsList(ApplicationUser user, Collection<Approval> approvals, io.atlassian.fugue.Option<RequestStatusMapper> statusMapper) {
        Comparator byCreatedDate = (a1, a2) -> a2.getCreatedDate().compareTo(a1.getCreatedDate());
        return approvals.stream().sorted(byCreatedDate).map(approval -> this.getApprovalPortalViewData(user, (Approval)approval, statusMapper)).collect(Collectors.toList());
    }

    private ApprovalIssueViewData getApprovalIssueViewData(ApplicationUser user, Approval approval, io.atlassian.fugue.Option<RequestStatusMapper> statusMapper) {
        return this.getIssueViewApproversLists(user, approval, this.getApprovalConfiguration(approval), this.getApprovalName(approval, statusMapper), this.getFinalDecision(approval), this.getPendingCount(user, approval));
    }

    private ApprovalPortalViewData getApprovalPortalViewData(ApplicationUser user, Approval approval, io.atlassian.fugue.Option<RequestStatusMapper> statusMapper) {
        return this.getPortalViewApproversLists(user, approval, this.getApprovalName(approval, statusMapper), this.getFinalDecision(approval), this.getPendingCount(user, approval));
    }

    private ApprovalDecisionViewData getFinalDecision(Approval approval) {
        return ApprovalDecisionViewData.forApproval(approval);
    }

    private Integer getPendingCount(ApplicationUser user, Approval approval) {
        return (Integer)this.approvalRequirementService.getRemainingApproveDecisionsUntilApproved(user, approval).getOrNull();
    }

    private ApprovalConfigurationViewData getApprovalConfiguration(Approval approval) {
        Collection<ApproverConfigurationViewData> approverConfigurations = this.getApproverConfigurations(approval);
        ApprovalConditionViewData condition = this.getApproveCondition(approval);
        return new ApprovalConfigurationViewData(approverConfigurations, condition);
    }

    private Collection<ApproverConfigurationViewData> getApproverConfigurations(Approval approval) {
        Collection approverConfigurations = this.approverService.getApproverConfigurations(approval);
        ArrayList<ApproverConfigurationViewData> viewDatas = new ArrayList<ApproverConfigurationViewData>();
        for (ApproverConfiguration config : approverConfigurations) {
            io.atlassian.fugue.Option<ApproverConfigurationViewData> viewDataOpt = this.toViewData(config);
            if (!viewDataOpt.isDefined()) continue;
            viewDatas.add((ApproverConfigurationViewData)viewDataOpt.get());
        }
        return viewDatas;
    }

    private io.atlassian.fugue.Option<ApproverConfigurationViewData> toViewData(ApproverConfiguration config) {
        ApproverConfigurationType type = config.getType();
        switch (type) {
            case USER: {
                UserApproverConfiguration userConfig = (UserApproverConfiguration)config;
                ApplicationUser user = userConfig.getUser();
                return io.atlassian.fugue.Option.some((Object)new ApproverConfigurationViewData(type.value(), user.getUsername(), user.getDisplayName(), null, null));
            }
            case CUSTOM_FIELD: {
                CustomFieldApproverConfiguration cfConfig = (CustomFieldApproverConfiguration)config;
                CustomField customField = cfConfig.getCustomField();
                return io.atlassian.fugue.Option.some((Object)new ApproverConfigurationViewData(type.value(), null, null, customField.getFieldName(), customField.getId()));
            }
        }
        return io.atlassian.fugue.Option.none();
    }

    private ApprovalConditionViewData getApproveCondition(Approval approval) {
        ApprovalCondition approvedCondition = this.approvalRequirementService.getApprovedCondition(approval);
        return new ApprovalConditionViewData(approvedCondition.getConditionType(), Integer.parseInt(approvedCondition.getConditionValue()));
    }

    private ApprovalIssueViewData getIssueViewApproversLists(ApplicationUser user, Approval approval, ApprovalConfigurationViewData configuration, String approvalName, ApprovalDecisionViewData finalDecision, Integer pendingCount) {
        Either approversEither = this.approverService.getApprovers(user, approval);
        if (approversEither.isLeft()) {
            return new ApprovalIssueViewData(String.valueOf(approval.getId()), approvalName, configuration, Collections.emptyList(), finalDecision, pendingCount);
        }
        Set<ApproverDetailedViewData> allApproversDecisions = this.getAllDecisions(approval, (Either<AnError, Collection<ApplicationUser>>)approversEither);
        return new ApprovalIssueViewData(String.valueOf(approval.getId()), approvalName, configuration, (List<ApproverDetailedViewData>)ImmutableList.copyOf(allApproversDecisions), finalDecision, pendingCount);
    }

    private ApprovalPortalViewData getPortalViewApproversLists(ApplicationUser user, Approval approval, String approvalName, ApprovalDecisionViewData finalDecision, Integer pendingCount) {
        Either approversEither = this.approverService.getApprovers(user, approval);
        if (approversEither.isLeft()) {
            return new ApprovalPortalViewData(approvalName, Collections.emptyList(), finalDecision, pendingCount);
        }
        Set<ApproverDetailedViewData> allApproversDecisions = this.getAllDecisions(approval, (Either<AnError, Collection<ApplicationUser>>)approversEither);
        return new ApprovalPortalViewData(approvalName, (List<ApproverDetailedViewData>)ImmutableList.copyOf(allApproversDecisions), finalDecision, pendingCount);
    }

    private Set<ApproverDetailedViewData> getAllDecisions(Approval approval, Either<AnError, Collection<ApplicationUser>> approversEither) {
        Collection approversDecisions = this.approverDecisionService.getApproversDecisions(approval);
        Collection approvers = (Collection)approversEither.right().get();
        Set<ApproverDetailedViewData> availableApproversDecisions = this.getAvailableApproversDecisions(approversDecisions, approvers);
        Set<ApproverDetailedViewData> persistedApproversDecisions = this.toViewData(approversDecisions);
        return this.getAllApproversDecisions(availableApproversDecisions, persistedApproversDecisions);
    }

    private Set<ApproverDetailedViewData> getAllApproversDecisions(Set<ApproverDetailedViewData> availableApproversDecisions, Set<ApproverDetailedViewData> persistedApproversDecisions) {
        HashSet<ApproverDetailedViewData> allApproversDecisions = new HashSet<ApproverDetailedViewData>(availableApproversDecisions);
        allApproversDecisions.addAll(persistedApproversDecisions);
        return ImmutableSet.copyOf(allApproversDecisions);
    }

    private Set<ApproverDetailedViewData> getAvailableApproversDecisions(Collection<ApproverDecision> approversDecisions, Collection<ApplicationUser> approvers) {
        Set availableApproversDecisions = approvers.stream().map(approver -> this.toViewData((ApplicationUser)approver, approversDecisions)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(availableApproversDecisions);
    }

    private ApproverDetailedViewData toViewData(ApplicationUser approver, Collection<ApproverDecision> approversDecisions) {
        ApproverDetailedViewData data = new ApproverDetailedViewData();
        String userKey = approver.getKey();
        data.setUserKey(userKey);
        data.setAvatarUrl(this.getAvatarUrl(approver));
        data.setUsername(approver.getUsername());
        data.setDisplayName(approver.getDisplayName());
        data.setDecision(this.getApproverDecision(approver, approversDecisions));
        return data;
    }

    private ApprovalDecisionViewData getApproverDecision(ApplicationUser approver, Collection<ApproverDecision> approversDecisions) {
        String userKey = approver.getKey();
        for (ApproverDecision approversDecision : approversDecisions) {
            if (!userKey.equals(approversDecision.getUserKey())) continue;
            return ApprovalDecisionViewData.forApprovalDecision(approversDecision.getDecision());
        }
        return ApprovalDecisionViewData.PENDING;
    }

    private Set<ApproverDetailedViewData> toViewData(Collection<ApproverDecision> approversDecisions) {
        Set viewData = approversDecisions.stream().map(this::toApproverDetailedViewData).collect(Collectors.toSet());
        return ImmutableSet.copyOf(viewData);
    }

    private ApproverDetailedViewData toApproverDetailedViewData(ApproverDecision decision) {
        ApproverDetailedViewData data = new ApproverDetailedViewData();
        String userKey = decision.getUserKey();
        data.setUserKey(userKey);
        io.atlassian.fugue.Option.option((Object)this.userManager.getUserByKey(userKey)).fold(() -> {
            data.setDisplayName(userKey);
            return data;
        }, user -> {
            data.setDisplayName(user.getDisplayName());
            data.setUsername(user.getUsername());
            data.setAvatarUrl(this.getAvatarUrl((ApplicationUser)user));
            return data;
        });
        data.setDecision(ApprovalDecisionViewData.forApprovalDecision(decision.getDecision()));
        return data;
    }

    private String getAvatarUrl(ApplicationUser user) {
        return this.avatarService.getAvatarURL(this.jiraAuthenticationContext.getLoggedInUser(), user, Avatar.Size.SMALL).toASCIIString();
    }

    private RequestStatusMapper getStatusMapper(ApplicationUser user, Issue issue) {
        io.atlassian.fugue.Option requestTypeOption = StepsConverters.newerOption((Option)this.requestTypeService.getRequestTypeForIssue(user, issue).toOption());
        return this.requestStatusService.getStatusMapper(requestTypeOption);
    }

    private String getApprovalName(Approval approval, io.atlassian.fugue.Option<RequestStatusMapper> statusMapper) {
        if (statusMapper.isEmpty() || StringUtils.isEmpty((CharSequence)approval.getStatusId())) {
            return approval.getName();
        }
        return ((RequestStatusMapper)statusMapper.get()).translateToCustomerStatus(approval.getStatusId(), approval.getName());
    }
}

