/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalRequirementService;
import com.atlassian.servicedesk.internal.api.visiblefortesting.ApprovalsBackdoor;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalDecisionTypeValueHelper;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class ApprovalsBackdoorImpl
implements ApprovalsBackdoor {
    private ApprovalRequirementService approvalRequirementService;
    private InternalApprovalService approvalService;

    @Autowired
    public ApprovalsBackdoorImpl(ApprovalRequirementService approvalRequirementService, InternalApprovalService approvalService) {
        this.approvalRequirementService = approvalRequirementService;
        this.approvalService = approvalService;
    }

    public Either<AnError, String> getFinalDecision(ApplicationUser user, int approvalId) {
        Either approvalEither = this.approvalService.getApprovalById(user, approvalId);
        return approvalEither.map(approval -> this.getDecision(user, (Approval)approval));
    }

    private String getDecision(ApplicationUser user, Approval approval) {
        return (String)approval.getDecision().map(decisionType -> ApprovalDecisionTypeValueHelper.toDatabaseValue(decisionType)).getOrElse(this.approvalRequirementService.calculateDecision(user, approval).map(decision -> ApprovalDecisionTypeValueHelper.toDatabaseValue(decision)).getOrElse((Object)"pending"));
    }
}

