/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.util;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.customfield.CustomFieldTypeChecker;
import com.atlassian.servicedesk.plugins.approvals.internal.customfield.ApprovalsCFTypeCheckerService;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalFieldsProvider;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalFieldsProviderImpl
implements ApprovalFieldsProvider {
    private final CustomFieldManager customFieldManager;
    private final CustomFieldTypeChecker customFieldTypeChecker;
    private final ApprovalsCFTypeCheckerService approvalsCFTypeCheckerService;

    @Autowired
    public ApprovalFieldsProviderImpl(FieldManager fieldManager, CustomFieldTypeChecker customFieldTypeChecker, ApprovalsCFTypeCheckerService approvalsCFTypeCheckerService, CustomFieldManager customFieldManager) {
        this.customFieldTypeChecker = customFieldTypeChecker;
        this.approvalsCFTypeCheckerService = approvalsCFTypeCheckerService;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public List<CustomField> getEligibleFields(ApplicationUser user) {
        List<CustomField> customUserFields = this.customFieldManager.getCustomFieldObjects().stream().filter(this::isSupportedUserField).collect(Collectors.toList());
        Collections.sort(customUserFields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        return customUserFields;
    }

    private boolean isSupportedUserField(CustomField field) {
        if (!FieldPredicates.isCustomUserField().evaluate((Object)field)) {
            return false;
        }
        return !this.approvalsCFTypeCheckerService.isGroupCustomField(field) && !this.customFieldTypeChecker.isRequestParticipantsCustomField(field) && !this.customFieldTypeChecker.isCustomerOrganisationsCustomField(field);
    }
}

