/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher.query;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.ApprovalsFunctionType;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.ApprovalsClauseQueryCreationService;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.ApprovedClauseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.ApproverClauseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.DefaultFalseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.MyApprovalClauseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.MyPendingClauseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.PendingByClauseQueryCreation;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.query.PendingClauseQueryCreation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsClauseQueryCreationDelegator {
    private Logger logger = LoggerFactory.getLogger(ApprovalsClauseQueryCreationDelegator.class);
    private final PendingClauseQueryCreation pendingClauseQueryCreation;
    private final ApprovedClauseQueryCreation approvedClauseQueryCreation;
    private final ApproverClauseQueryCreation approverClauseQueryCreation;
    private final DefaultFalseQueryCreation defaultFalseQueryCreation;
    private final MyApprovalClauseQueryCreation myApprovalClauseQueryCreation;
    private final PendingByClauseQueryCreation pendingByClauseQueryCreation;
    private final MyPendingClauseQueryCreation myPendingClauseQueryCreation;

    @Autowired
    public ApprovalsClauseQueryCreationDelegator(PendingClauseQueryCreation pendingClauseQueryCreation, ApprovedClauseQueryCreation approvedClauseQueryCreation, ApproverClauseQueryCreation approverClauseQueryCreation, DefaultFalseQueryCreation defaultFalseQueryCreation, MyApprovalClauseQueryCreation myApprovalClauseQueryCreation, PendingByClauseQueryCreation pendingByClauseQueryCreation, MyPendingClauseQueryCreation myPendingClauseQueryCreation) {
        this.pendingClauseQueryCreation = pendingClauseQueryCreation;
        this.approvedClauseQueryCreation = approvedClauseQueryCreation;
        this.approverClauseQueryCreation = approverClauseQueryCreation;
        this.defaultFalseQueryCreation = defaultFalseQueryCreation;
        this.myApprovalClauseQueryCreation = myApprovalClauseQueryCreation;
        this.pendingByClauseQueryCreation = pendingByClauseQueryCreation;
        this.myPendingClauseQueryCreation = myPendingClauseQueryCreation;
    }

    public QueryFactoryResult createQuery(ApplicationUser user, CustomField field, TerminalClause terminalClause) {
        return this.getCreationServiceBasedOnOperand(terminalClause).createQuery(user, field, terminalClause);
    }

    public ApprovalsClauseQueryCreationService getCreationServiceBasedOnOperand(TerminalClause terminalClause) {
        ApprovalsFunctionType functionType = ApprovalsFunctionType.getFunctionType(terminalClause.getOperand());
        switch (functionType) {
            case PENDING: {
                return this.pendingClauseQueryCreation;
            }
            case APPROVED: {
                return this.approvedClauseQueryCreation;
            }
            case APPROVER: {
                return this.approverClauseQueryCreation;
            }
            case MY_APPROVAL: {
                return this.myApprovalClauseQueryCreation;
            }
            case PENDING_BY: {
                return this.pendingByClauseQueryCreation;
            }
            case MY_PENDING: {
                return this.myPendingClauseQueryCreation;
            }
        }
        this.logger.warn("Unkown Approvals JQL Function %s - %s", (Object)terminalClause.getOperand().getName(), (Object)terminalClause.getOperand().getDisplayString());
        return this.defaultFalseQueryCreation;
    }
}

