/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher;

import com.atlassian.query.operand.Operand;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.function.ApprovalsFunctionHelper;

public enum ApprovalsFunctionType {
    PENDING,
    APPROVED,
    APPROVER,
    MY_APPROVAL,
    PENDING_BY,
    MY_PENDING,
    UNKNOWN;


    public static ApprovalsFunctionType getFunctionType(Operand operand) {
        if (ApprovalsFunctionHelper.isPendingFunctionOperand(operand)) {
            return PENDING;
        }
        if (ApprovalsFunctionHelper.isApprovedFunctionOperand(operand)) {
            return APPROVED;
        }
        if (ApprovalsFunctionHelper.isApproverFunctionOperand(operand)) {
            return APPROVER;
        }
        if (ApprovalsFunctionHelper.isMyApprovalFunctionOperand(operand)) {
            return MY_APPROVAL;
        }
        if (ApprovalsFunctionHelper.isPendingByFunctionOperand(operand)) {
            return PENDING_BY;
        }
        if (ApprovalsFunctionHelper.isMyPendingFunctionOperand(operand)) {
            return MY_PENDING;
        }
        return UNKNOWN;
    }
}

