/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.searcher;

import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.lifecycle.ApprovalComponentAccessor;
import com.atlassian.servicedesk.plugins.approvals.internal.searcher.ApprovalsFunctionType;
import com.google.common.collect.Sets;
import java.util.Collection;
import javax.annotation.Nonnull;

public class ApprovalsClauseValidator
implements ClauseValidator {
    private static final SupportedOperatorsValidator SUPPORTED_OPERATORS_VALIDATOR = new SupportedOperatorsValidator(new Collection[]{Sets.immutableEnumSet((Enum)Operator.EQUALS, (Enum[])new Operator[0])});
    private static final String SUPPORTED_FUNCTION_NAMES = String.format("%s, %s, %s, %s, %s, %s", "pending", "pendingBy", "approved", "approver", "myApproval", "myPending");

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl msgs = new MessageSetImpl();
        msgs.addMessageSet(this.validateSupportedOperator(searcher, terminalClause));
        msgs.addMessageSet(this.validateSupportedOperand(terminalClause));
        return msgs;
    }

    private MessageSet validateSupportedOperator(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        return SUPPORTED_OPERATORS_VALIDATOR.validate(searcher, terminalClause);
    }

    private MessageSet validateSupportedOperand(@Nonnull TerminalClause terminalClause) {
        MessageSetImpl erorrMsg = new MessageSetImpl();
        if (!this.isSupported(ApprovalsFunctionType.getFunctionType(terminalClause.getOperand()))) {
            erorrMsg.addErrorMessage(this.getUnsupportedFunctionError());
        }
        return erorrMsg;
    }

    private boolean isSupported(ApprovalsFunctionType functionType) {
        return ApprovalsFunctionType.UNKNOWN != functionType;
    }

    private String getUnsupportedFunctionError() {
        return ApprovalComponentAccessor.getI18nHelper().getText("sd.approvals.jql.unsupported.query", SUPPORTED_FUNCTION_NAMES);
    }
}

