/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow;

import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.WorkflowApprovalAssembler;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.workflow.request.WorkflowApprovalRequest;
import io.atlassian.fugue.Unit;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="approval/workflow")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkflowApprovalResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowApprovalAssembler approvalConfigurationAssembler;
    private final RestResponseHelper restResponseHelper;
    private static final Function<AnError, AnError> ANERROR_WITH_MESSAGE_AS_REASON_KEY = anError -> new AnError(anError.getMessage(), anError.getHttpStatusCode(), new ErrorCode(anError.getMessage().getMessage()));

    public WorkflowApprovalResource(JiraAuthenticationContext jiraAuthenticationContext, WorkflowApprovalAssembler approvalConfigurationAssembler, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.approvalConfigurationAssembler = approvalConfigurationAssembler;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="configurations")
    public Response getCreateApprovalConfig(@QueryParam(value="workflowName") String workflowName) {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalConfigurationAssembler.getConfigurations(this.jiraAuthenticationContext.getLoggedInUser(), workflowName).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @PUT
    @Path(value="status/{statusId}/configuration")
    public Response updateApprovalConfig(@QueryParam(value="workflowName") String workflowName, @PathParam(value="statusId") long statusId, WorkflowApprovalRequest configureApprovalRequest) throws FieldException {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalConfigurationAssembler.updateConfiguration(this.jiraAuthenticationContext.getLoggedInUser(), workflowName, statusId, configureApprovalRequest).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @GET
    @Path(value="status/{statusId}/configuration")
    public Response getApprovalConfig(@QueryParam(value="workflowName") String workflowName, @PathParam(value="statusId") long statusId, WorkflowApprovalRequest configureApprovalRequest) throws FieldException {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalConfigurationAssembler.getConfiguration(this.jiraAuthenticationContext.getLoggedInUser(), workflowName, statusId).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }

    @PUT
    @Path(value="status/{statusId}/configuration/activate")
    public Response activateApprovalConfig(@QueryParam(value="workflowName") String workflowName, @PathParam(value="statusId") long statusId) throws FieldException {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(this.approvalConfigurationAssembler.activateConfiguration(this.jiraAuthenticationContext.getLoggedInUser(), workflowName, statusId).bimap(ANERROR_WITH_MESSAGE_AS_REASON_KEY, response -> Unit.Unit()));
    }

    @PUT
    @Path(value="status/{statusId}/configuration/deactivate")
    public Response deactivateApprovalConfig(@QueryParam(value="workflowName") String workflowName, @PathParam(value="statusId") long statusId) throws FieldException {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(this.approvalConfigurationAssembler.deactivateConfiguration(this.jiraAuthenticationContext.getLoggedInUser(), workflowName, statusId).bimap(ANERROR_WITH_MESSAGE_AS_REASON_KEY, response -> Unit.Unit()));
    }

    @GET
    @Path(value="status/{statusId}/configuration/options")
    public Response getApprovalConfigOptions(@QueryParam(value="workflowName") String workflowName, @PathParam(value="statusId") long statusId) throws FieldException {
        return this.restResponseHelper.anErrorEitherToOkResponse(this.approvalConfigurationAssembler.getApprovalConfigurationOptions(this.jiraAuthenticationContext.getLoggedInUser(), workflowName, statusId).leftMap(ANERROR_WITH_MESSAGE_AS_REASON_KEY));
    }
}

