/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest.response;

import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalImpl;
import java.time.Instant;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ApprovalResponse {
    private int id;
    private long issueId;
    private String name;
    private String statusId;
    private ApprovalDecisionType decision;
    private long createdDate;
    private Long completedDate;

    public ApprovalResponse(ApprovalImpl approval) {
        this.id = approval.getId();
        this.issueId = approval.getIssueId();
        this.name = approval.getName();
        this.statusId = approval.getStatusId();
        this.decision = (ApprovalDecisionType)approval.getDecision().getOrNull();
        this.createdDate = approval.getCreatedDate().toEpochMilli();
        this.completedDate = approval.getCompletedDate().isDefined() ? Long.valueOf(((Instant)approval.getCompletedDate().get()).toEpochMilli()) : null;
    }

    public int getId() {
        return this.id;
    }

    public long getIssueId() {
        return this.issueId;
    }

    public String getName() {
        return this.name;
    }

    public ApprovalDecisionType getDecision() {
        return this.decision;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public Long getCompletedDate() {
        return this.completedDate;
    }

    public String getStatusId() {
        return this.statusId;
    }
}

