/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.rest.ApprovalAssembler;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="customer/approval")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerPortalApprovalResource {
    private final ApprovalAssembler approvalAssembler;
    private final RestResponseHelper restResponseHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final Function<AnError, AnError> ANERROR_WITH_MESSAGE_AS_REASON_KEY = anError -> new AnError(anError.getMessage(), anError.getHttpStatusCode(), new ErrorCode(anError.getMessage().getMessage()));

    public CustomerPortalApprovalResource(JiraAuthenticationContext jiraAuthenticationContext, ApprovalAssembler approvalAssembler, RestResponseHelper restResponseHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.approvalAssembler = approvalAssembler;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    @Path(value="/{approvalId}/approve")
    public Response approveApproval(@PathParam(value="approvalId") Integer approvalId) {
        Either result = this.approvalAssembler.approveApproval(this.getApplicationUser(), approvalId).bimap(ANERROR_WITH_MESSAGE_AS_REASON_KEY, response -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    @POST
    @Path(value="/{approvalId}/reject")
    public Response rejectApproval(@PathParam(value="approvalId") int approvalId) {
        Either result = this.approvalAssembler.rejectApproval(this.getApplicationUser(), approvalId).bimap(ANERROR_WITH_MESSAGE_AS_REASON_KEY, response -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    private ApplicationUser getApplicationUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

