/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.notification;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.notifications.approvals.ApprovalsNotificationSenderService;
import com.atlassian.servicedesk.internal.api.notifications.approvals.RequestToApproveNotificationsData;
import com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.featureflag.SDApprovalsFeatureFlags;
import com.atlassian.servicedesk.plugins.approvals.internal.notification.ApprovalNotificationService;
import com.atlassian.servicedesk.plugins.approvals.internal.notification.ApprovalRequestedEventImpl;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalNotificationServiceImpl
implements ApprovalNotificationService {
    private final ApprovalsNotificationSenderService notificationSenderService;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    @Autowired
    public ApprovalNotificationServiceImpl(ApprovalsNotificationSenderService notificationSenderService, EventPublisher eventPublisher, FeatureManager featureManager) {
        this.notificationSenderService = notificationSenderService;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
    }

    @Override
    public void sendRequestToApproveNotifications(Option<ApplicationUser> initiator, Issue issue, Set<ApplicationUser> approvers, Date originalEventTime) {
        if (!this.featureManager.isEnabled("sd.custom.email.notifications.cut.over")) {
            this.sendLegacyNotifications(issue, approvers);
        }
        this.publishApprovalRequestedNotificationEvent(initiator, issue, approvers, originalEventTime);
    }

    private Collection<ApplicationUser> sendLegacyNotifications(Issue issue, Set<ApplicationUser> approvers) {
        if (!approvers.isEmpty()) {
            RequestToApproveNotificationsData notificationsData = this.notificationSenderService.requestToApproveDataBuilder().issue(issue).approvers(approvers).build();
            return this.notificationSenderService.sendRequestToApproveNotifications(notificationsData);
        }
        return Lists.newArrayList();
    }

    private void publishApprovalRequestedNotificationEvent(Option<ApplicationUser> initiator, Issue issue, Collection<ApplicationUser> approversToNotify, Date originalEventTime) {
        if (this.featureManager.isEnabled(SDApprovalsFeatureFlags.APPROVAL_REQUESTED_WHEN_HANDLER) && !approversToNotify.isEmpty()) {
            this.eventPublisher.publish((Object)new ApprovalRequestedEventImpl(initiator, issue, approversToNotify, originalEventTime));
        }
    }
}

