/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationDelegator;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApprovalData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.IssueApprovalData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.IssueApprovalDataDao;
import com.atlassian.servicedesk.plugins.approvals.internal.issue.ApprovalUserData;
import com.atlassian.servicedesk.plugins.approvals.internal.issue.IssueApprovalUserData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueApprovalDataManager {
    private final DatabaseAccessor databaseAccessor;
    private final IssueApprovalDataDao issueApprovalDataDao;
    private final ApproverConfigurationDelegator approverConfigurationDelegator;
    private final ApprovalManager approvalManager;

    @Autowired
    public IssueApprovalDataManager(DatabaseAccessor databaseAccessor, IssueApprovalDataDao issueApprovalDataDao, ApproverConfigurationDelegator approverConfigurationDelegator, ApprovalManager approvalManager) {
        this.databaseAccessor = databaseAccessor;
        this.issueApprovalDataDao = issueApprovalDataDao;
        this.approverConfigurationDelegator = approverConfigurationDelegator;
        this.approvalManager = approvalManager;
    }

    public IssueApprovalUserData getIssueApprovalData(Issue issue) {
        IssueApprovalData issueApprovalData = (IssueApprovalData)this.databaseAccessor.run(databaseConnection -> this.issueApprovalDataDao.getApprovalIndexDbData(issue, (DatabaseConnection)databaseConnection));
        List<ApprovalUserData> approvalUserDatas = issueApprovalData.getApprovalDatas().stream().filter(data -> this.approvalManager.isValidApproval(issue, data.getApproval())).map(validApproval -> this.includeUserDatasInIssueApprovalData(issue, (ApprovalData)validApproval)).collect(Collectors.toList());
        return new IssueApprovalUserData(issue, approvalUserDatas);
    }

    private ApprovalUserData includeUserDatasInIssueApprovalData(Issue issue, ApprovalData indexDBData) {
        Set<ApproverConfigurationData> configurationDatas = indexDBData.getApproverConfigurationDatas();
        Set<ApplicationUser> users = this.approverConfigurationDelegator.getApprovers(issue, configurationDatas);
        return new ApprovalUserData(issue, indexDBData.getApproval(), users, indexDBData.getApproverDecisions());
    }
}

