/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events.listeners;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.configuration.WorkflowApprovalConfigurationManager;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowEventListener {
    private final ReindexMessageManager reindexMessageManager;
    private final WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final ServiceDeskManager serviceDeskManager;
    private final IssueManager issueManager;

    @Autowired
    public WorkflowEventListener(ReindexMessageManager reindexMessageManager, WorkflowApprovalConfigurationManager workflowApprovalConfigurationManager, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, ServiceDeskManager serviceDeskManager, IssueManager issueManager) {
        this.reindexMessageManager = reindexMessageManager;
        this.workflowApprovalConfigurationManager = workflowApprovalConfigurationManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.serviceDeskManager = serviceDeskManager;
        this.issueManager = issueManager;
    }

    public void handleWorkflowSchemeUpdatedEvent(WorkflowSchemeUpdatedEvent workflowSchemeUpdatedEvent) {
        Map<String, String> schemeMappings;
        boolean handledNullPossibilities;
        Scheme originalScheme = workflowSchemeUpdatedEvent.getOriginalScheme();
        Scheme scheme = workflowSchemeUpdatedEvent.getScheme();
        if (originalScheme == null && scheme == null) {
            return;
        }
        if (originalScheme == null) {
            handledNullPossibilities = this.isAnyActiveApprovalConfigurationsOnScheme(scheme);
        } else {
            boolean bl = handledNullPossibilities = scheme == null && this.isAnyActiveApprovalConfigurationsOnScheme(originalScheme);
        }
        if (handledNullPossibilities) {
            this.pushReindexMessage("sd.approval.assigned.reindex.message");
            return;
        }
        Map<String, String> originalSchemeMappings = this.mappingSchemeEntities(originalScheme);
        if (Objects.equals(originalSchemeMappings, schemeMappings = this.mappingSchemeEntities(scheme))) {
            return;
        }
        MapDifference difference = Maps.difference(originalSchemeMappings, schemeMappings);
        boolean anyOnlyActive = Stream.concat(difference.entriesOnlyOnLeft().values().stream(), difference.entriesOnlyOnRight().values().stream()).anyMatch(workflowName -> {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
            return workflow != null && Iterables.any(this.workflowApprovalConfigurationManager.getConfigurations(workflow), WorkflowApprovalConfiguration::isActive);
        });
        if (anyOnlyActive) {
            this.pushReindexMessage("sd.approval.assigned.reindex.message");
            return;
        }
        boolean anyDifferencesChangedActiveState = difference.entriesDiffering().values().stream().anyMatch(differences -> {
            JiraWorkflow originalWorkflow = this.workflowManager.getWorkflow((String)differences.leftValue());
            JiraWorkflow workflow = this.workflowManager.getWorkflow((String)differences.rightValue());
            return this.isWorkflowActiveStatesChanged(originalWorkflow, workflow);
        });
        if (anyDifferencesChangedActiveState) {
            this.pushReindexMessage("sd.approval.assigned.reindex.message");
        }
    }

    public void handleWorkflowSchemeRemovedFromProjectEvent(WorkflowSchemeRemovedFromProjectEvent workflowSchemeRemovedFromProjectEvent) {
        if (!this.serviceDeskManager.isServiceDeskProject(workflowSchemeRemovedFromProjectEvent.getProject())) {
            return;
        }
        if (!this.isProjectWithIssues(workflowSchemeRemovedFromProjectEvent.getProject())) {
            return;
        }
        if (this.isAnyActiveApprovalConfigurationsOnScheme(workflowSchemeRemovedFromProjectEvent.getScheme())) {
            this.pushReindexMessage("sd.approval.assigned.reindex.message");
        }
    }

    public void handleWorkflowSchemeAddedToProjectEvent(WorkflowSchemeAddedToProjectEvent workflowSchemeAddedToProjectEvent) {
        if (!this.serviceDeskManager.isServiceDeskProject(workflowSchemeAddedToProjectEvent.getProject())) {
            return;
        }
        if (!this.isProjectWithIssues(workflowSchemeAddedToProjectEvent.getProject())) {
            return;
        }
        if (this.isAnyActiveApprovalConfigurationsOnScheme(workflowSchemeAddedToProjectEvent.getScheme())) {
            this.pushReindexMessage("sd.approval.assigned.reindex.message");
        }
    }

    public void handleDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent draftWorkflowPublishedEvent) {
        JiraWorkflow workflow;
        JiraWorkflow originalWorkflow = draftWorkflowPublishedEvent.getOriginalWorkflow();
        boolean present = this.isWorkflowActiveStatesChanged(originalWorkflow, workflow = draftWorkflowPublishedEvent.getWorkflow());
        if (present) {
            this.pushReindexMessage("sd.approval.active.reindex.message");
        }
    }

    private boolean isWorkflowActiveStatesChanged(@Nullable JiraWorkflow originalWorkflow, @Nullable JiraWorkflow workflow) {
        if (originalWorkflow == null && workflow == null) {
            return false;
        }
        if (originalWorkflow == null) {
            return Iterables.any(this.workflowApprovalConfigurationManager.getConfigurations(workflow), WorkflowApprovalConfiguration::isActive);
        }
        if (workflow == null) {
            return Iterables.any(this.workflowApprovalConfigurationManager.getConfigurations(originalWorkflow), WorkflowApprovalConfiguration::isActive);
        }
        List<WorkflowApprovalConfiguration> previousConfigurations = this.workflowApprovalConfigurationManager.getConfigurations(originalWorkflow);
        if (previousConfigurations.isEmpty()) {
            return false;
        }
        List<WorkflowApprovalConfiguration> currentConfigurations = this.workflowApprovalConfigurationManager.getConfigurations(workflow);
        return previousConfigurations.stream().anyMatch(previousConfiguration -> {
            String previousStatusId = previousConfiguration.getStatusId();
            boolean previouslyActive = previousConfiguration.isActive();
            Set relatedConfigurations = currentConfigurations.stream().filter(currentConfiguration -> Objects.equals(previousStatusId, currentConfiguration.getStatusId())).collect(Collectors.toSet());
            return relatedConfigurations.isEmpty() && previouslyActive || Iterables.any(relatedConfigurations, currentConfiguration -> previouslyActive != currentConfiguration.isActive());
        });
    }

    private boolean isAnyActiveApprovalConfigurationsOnScheme(@Nullable Scheme scheme) {
        return ((List)Option.option((Object)scheme).map(Scheme::getId).map(arg_0 -> ((WorkflowSchemeManager)this.workflowSchemeManager).getSchemeObject(arg_0)).flatMap(workflowScheme -> Option.some(workflowScheme.getEntities().stream().flatMap(entity -> StreamSupport.stream(Option.option((Object)this.workflowManager.getWorkflow(String.valueOf(entity.getEntityTypeId()))).spliterator(), false)).collect(Collectors.toList()))).getOrElse(Collections.emptyList())).stream().map(this.workflowApprovalConfigurationManager::getConfigurations).anyMatch(configurations -> Iterables.any((Iterable)configurations, WorkflowApprovalConfiguration::isActive));
    }

    private Map<String, String> mappingSchemeEntities(Scheme scheme) {
        List<Pair> collect = scheme.getEntities().stream().map(schemeEntity -> Pair.pair((Object)schemeEntity.getParameter(), (Object)String.valueOf(schemeEntity.getEntityTypeId()))).collect(Collectors.toList());
        HashMap<String, String> mapping = new HashMap<String, String>();
        collect.forEach(pair -> {
            String cfr_ignored_0 = (String)mapping.put((String)pair.left(), (String)pair.right());
        });
        return mapping;
    }

    private boolean isProjectWithIssues(Project project) {
        return this.issueManager.getIssueCountForProject(project.getId()) > 0L;
    }

    private void pushReindexMessage(String i18nTask) {
        this.reindexMessageManager.pushMessage(null, i18nTask);
    }
}

