/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.util.IssueEventHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalCompletedEvent;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalCreatedEvent;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApproverFieldChangeData;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApproversFieldChangeHelper;
import com.atlassian.servicedesk.plugins.approvals.internal.events.handlers.ApprovalCreatedEventHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.events.handlers.ApproverFieldChangeHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.events.listeners.WorkflowEventListener;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.WorkflowApprovalCreationService;
import com.atlassian.servicedesk.plugins.approvals.internal.workflow.WorkflowApprovalService;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalsEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalsEventListener.class);
    private final WorkflowApprovalService workflowApprovalService;
    private final ApprovalCreatedEventHandler approvalCreatedEventHandler;
    private final ApproverFieldChangeHandler approverFieldChangeHandler;
    private final WorkflowApprovalCreationService workflowApprovalCreationService;
    private final ServiceDeskManager serviceDeskManager;
    private final ApproversFieldChangeHelper approversFieldChangeHelper;
    private final WorkflowEventListener workflowEventListener;
    private final IssueEventHelper issueEventHelper;

    @Autowired
    public ApprovalsEventListener(ApprovalCreatedEventHandler approvalCreatedEventHandler, ApproverFieldChangeHandler approverFieldChangeHandler, WorkflowApprovalService workflowApprovalService, WorkflowApprovalCreationService workflowApprovalCreationService, ServiceDeskManager serviceDeskManager, ApproversFieldChangeHelper approversFieldChangeHelper, WorkflowEventListener workflowEventListener, IssueEventHelper issueEventHelper) {
        this.workflowApprovalService = workflowApprovalService;
        this.approvalCreatedEventHandler = approvalCreatedEventHandler;
        this.approverFieldChangeHandler = approverFieldChangeHandler;
        this.workflowApprovalCreationService = workflowApprovalCreationService;
        this.serviceDeskManager = serviceDeskManager;
        this.approversFieldChangeHelper = approversFieldChangeHelper;
        this.workflowEventListener = workflowEventListener;
        this.issueEventHelper = issueEventHelper;
    }

    @EventListener
    public void onApprovalCompleted(@Nonnull ApprovalCompletedEvent approvalCompletedEvent) {
        try {
            this.workflowApprovalService.handleApprovalCompletion(approvalCompletedEvent.getUser(), approvalCompletedEvent.getApproval());
        }
        catch (Exception e) {
            logger.warn("exception handling approval completion event", (Throwable)e);
        }
    }

    @EventListener
    public void onApprovalCreated(ApprovalCreatedEvent approvalCreatedEvent) {
        try {
            this.approvalCreatedEventHandler.handleCreated(approvalCreatedEvent);
        }
        catch (Exception e) {
            logger.warn("exception handling approval creation event", (Throwable)e);
        }
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        Issue issue = issueEvent.getIssue();
        if (this.issueEventHelper.isCreatedEvent(issueEvent) && this.isApplicableIssue(issue)) {
            this.processPotentialApprovalCreation(issueEvent.getUser(), issue);
        }
    }

    @EventListener
    public void onIssueChangeEvent(IssueChangedEvent issueChangedEvent) {
        Issue issue = issueChangedEvent.getIssue();
        if (!this.isApplicableIssue(issue)) {
            return;
        }
        Option<Approval> approvalOption = this.processPotentialApprovalCreation(issueChangedEvent.getAuthor().orElse(null), issue);
        if (approvalOption.isEmpty()) {
            this.processPotentialApproverFieldChange(issueChangedEvent);
        }
    }

    @EventListener
    public void onDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent draftWorkflowPublishedEvent) {
        this.workflowEventListener.handleDraftWorkflowPublishedEvent(draftWorkflowPublishedEvent);
    }

    @EventListener
    public void onWorkflowSchemeUpdatedEvent(WorkflowSchemeUpdatedEvent workflowSchemeUpdatedEvent) {
        this.workflowEventListener.handleWorkflowSchemeUpdatedEvent(workflowSchemeUpdatedEvent);
    }

    @EventListener
    public void onWorkflowSchemeUpdatedEvent(WorkflowSchemeAddedToProjectEvent workflowSchemeAddedToProjectEvent) {
        this.workflowEventListener.handleWorkflowSchemeAddedToProjectEvent(workflowSchemeAddedToProjectEvent);
    }

    @EventListener
    public void onWorkflowSchemeUpdatedEvent(WorkflowSchemeRemovedFromProjectEvent workflowSchemeRemovedFromProjectEvent) {
        this.workflowEventListener.handleWorkflowSchemeRemovedFromProjectEvent(workflowSchemeRemovedFromProjectEvent);
    }

    private boolean isApplicableIssue(@Nullable Issue issue) {
        return issue != null && this.serviceDeskManager.isServiceDeskProject(issue.getProjectObject());
    }

    private Option<Approval> processPotentialApprovalCreation(ApplicationUser eventInitiator, Issue issue) {
        try {
            return this.workflowApprovalCreationService.handlePotentialApprovalCreation(eventInitiator, issue);
        }
        catch (Exception e) {
            logger.warn("exception handling approval creation based on issue transition event", (Throwable)e);
            return Option.none();
        }
    }

    private void processPotentialApproverFieldChange(IssueChangedEvent issueChangedEvent) {
        List<ApproverFieldChangeData> approverFieldChangeDatas = this.approversFieldChangeHelper.getApproversFieldChanges(issueChangedEvent);
        if (!approverFieldChangeDatas.isEmpty()) {
            try {
                this.approverFieldChangeHandler.handleApproverFieldChange(issueChangedEvent.getIssue(), issueChangedEvent.getAuthor().orElse(null), approverFieldChangeDatas, ApprovalsEventListener.toNonnullDateOrNow(issueChangedEvent.getTime()));
            }
            catch (Exception ex) {
                logger.warn("exception handling approver field change", (Throwable)ex);
            }
        }
    }

    private static Date toNonnullDateOrNow(Date nullableDate) {
        return (Date)Option.option((Object)nullableDate).getOrElse((Object)new Date());
    }
}

