/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events.handlers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approval.ApprovalChangeListenerService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApproverFieldChangeData;
import com.atlassian.servicedesk.plugins.approvals.internal.notification.ApprovalNotificationService;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproverFieldChangeHandler {
    private static final Logger logger = LoggerFactory.getLogger(ApproverFieldChangeHandler.class);
    private final ApprovalManager approvalManager;
    private final ApprovalNotificationService approvalNotificationService;
    private final ApprovalChangeListenerService approvalChangeListenerService;

    @Autowired
    public ApproverFieldChangeHandler(ApprovalManager approvalManager, ApprovalNotificationService approvalNotificationService, ApprovalChangeListenerService approvalChangeListenerService) {
        this.approvalManager = approvalManager;
        this.approvalNotificationService = approvalNotificationService;
        this.approvalChangeListenerService = approvalChangeListenerService;
    }

    public void handleApproverFieldChange(Issue issue, ApplicationUser user, List<ApproverFieldChangeData> approverFieldChangeDatas, Date eventTime) {
        Collection approvalIds = approverFieldChangeDatas.stream().map(data -> data.getApproverFieldConfiguration().getApprovalId()).collect(Collectors.toSet());
        Collection<Approval> approvals = this.approvalManager.getApprovalsByIds(approvalIds);
        this.approvalChangeListenerService.updateApprovalDecisionStateOrReturnOriginal(user, approvals);
        Set<ApplicationUser> approversRequiringNotification = this.getDistinctUsersForNotification(approverFieldChangeDatas);
        this.approvalNotificationService.sendRequestToApproveNotifications((Option<ApplicationUser>)Option.option((Object)user), issue, approversRequiringNotification, eventTime);
    }

    private Set<ApplicationUser> getDistinctUsersForNotification(Collection<ApproverFieldChangeData> approverFieldChangeDatas) {
        return approverFieldChangeDatas.stream().flatMap(changeData -> changeData.getNewlyAddedApprovers().stream()).collect(Collectors.toSet());
    }
}

