/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events.handlers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApprovalCreatedEvent;
import com.atlassian.servicedesk.plugins.approvals.internal.notification.ApprovalNotificationService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalCreatedEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalCreatedEventHandler.class);
    private final ApprovalManager approvalManager;
    private final ApprovalNotificationService notificationService;

    @Autowired
    public ApprovalCreatedEventHandler(ApprovalManager approvalManager, ApprovalNotificationService notificationService) {
        this.approvalManager = approvalManager;
        this.notificationService = notificationService;
    }

    public void handleCreated(ApprovalCreatedEvent createdEvent) {
        Approval approval = createdEvent.getApproval();
        Either<AnError, Issue> issue = this.approvalManager.getIssueForApproval(approval);
        if (issue.isLeft()) {
            logger.warn("Issue not found for ApprovalCreatedEvent");
            return;
        }
        this.notificationService.sendRequestToApproveNotifications((Option<ApplicationUser>)Option.option((Object)createdEvent.getUser()), (Issue)issue.right().get(), createdEvent.getAddedApprovers(), Date.from(createdEvent.getApproval().getCreatedDate()));
    }
}

