/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.events;

import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.approver.CustomFieldApproverConfiguration;
import com.atlassian.servicedesk.internal.api.events.UserChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.events.UsersAddedToCustomField;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverTypeConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.events.ApproverFieldChangeData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproversFieldChangeHelper {
    private final CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler;
    private final UserChangeItemBeanUtils userChangeItemBeanUtils;

    @Autowired
    public ApproversFieldChangeHelper(CustomFieldApproverTypeConfigurationHandler customFieldApproverTypeConfigurationHandler, UserChangeItemBeanUtils userChangeItemBeanUtils) {
        this.customFieldApproverTypeConfigurationHandler = customFieldApproverTypeConfigurationHandler;
        this.userChangeItemBeanUtils = userChangeItemBeanUtils;
    }

    public List<ApproverFieldChangeData> getApproversFieldChanges(IssueChangedEvent issueChangedEvent) {
        List<CustomFieldApproverConfiguration> approverConfigurationChanges = this.getApproverConfigurationChanges(issueChangedEvent);
        if (approverConfigurationChanges.isEmpty()) {
            return Collections.emptyList();
        }
        List<UsersAddedToCustomField> usersAddedToCustomFields = this.findAddedApproverPerCustomField(issueChangedEvent, approverConfigurationChanges);
        return this.getApproverFieldChangeDatas(approverConfigurationChanges, usersAddedToCustomFields);
    }

    private List<CustomFieldApproverConfiguration> getApproverConfigurationChanges(IssueChangedEvent issueChangedEvent) {
        Issue issue = issueChangedEvent.getIssue();
        Collection<CustomFieldApproverConfiguration> customFieldApproverConfigurations = this.customFieldApproverTypeConfigurationHandler.getApproverConfigurationForPendingApprovals(issue);
        if (customFieldApproverConfigurations.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> fieldChanges = this.getFieldChanges(issueChangedEvent);
        List<CustomFieldApproverConfiguration> approverConfigurationChanges = customFieldApproverConfigurations.stream().filter(config -> fieldChanges.contains(config.getCustomField().getFieldName())).collect(Collectors.toList());
        if (approverConfigurationChanges.isEmpty()) {
            return Collections.emptyList();
        }
        return approverConfigurationChanges;
    }

    private List<UsersAddedToCustomField> findAddedApproverPerCustomField(IssueChangedEvent issueChangedEvent, Collection<CustomFieldApproverConfiguration> customFieldApproverConfigurations) {
        List customFields = customFieldApproverConfigurations.stream().map(configuration -> configuration.getCustomField()).collect(Collectors.toList());
        return this.userChangeItemBeanUtils.findNewlyAddedUsersFromIssueChangeEvent(issueChangedEvent, customFields);
    }

    private List<ApproverFieldChangeData> getApproverFieldChangeDatas(Collection<CustomFieldApproverConfiguration> configurations, Collection<UsersAddedToCustomField> usersAddedToCustomFields) {
        return configurations.stream().map(configuration -> this.createApproverFieldChangeDataPerConfiguration((CustomFieldApproverConfiguration)configuration, usersAddedToCustomFields)).collect(Collectors.toList());
    }

    private ApproverFieldChangeData createApproverFieldChangeDataPerConfiguration(CustomFieldApproverConfiguration configuration, Collection<UsersAddedToCustomField> usersAddedToCustomFields) {
        Optional<UsersAddedToCustomField> usersAddedToCustomFieldForConfiguration = usersAddedToCustomFields.stream().filter(addedUserPerCf -> Objects.equals(addedUserPerCf.getCustomField().getFieldName(), configuration.getCustomField().getFieldName())).findFirst();
        if (!usersAddedToCustomFieldForConfiguration.isPresent()) {
            return new ApproverFieldChangeData(configuration, Collections.emptySet());
        }
        List addedUsers = usersAddedToCustomFieldForConfiguration.get().getAddedUsers();
        Set<ApplicationUser> addedApprovers = addedUsers.stream().map(CheckedUser::forJIRA).collect(Collectors.toSet());
        return new ApproverFieldChangeData(configuration, addedApprovers);
    }

    private Collection<String> getFieldChanges(IssueChangedEvent issueChangedEvent) {
        return issueChangedEvent.getChangeItems().stream().map(itemBean -> itemBean.getField()).collect(Collectors.toSet());
    }
}

